-- ============================================================
-- OptiCore SaaS - Seeds / Datos de Prueba
-- Ejecutar DESPUÉS de schema.sql
-- ============================================================

USE `opticore`;

-- ============================================================
-- PLANES
-- ============================================================
INSERT INTO `planes` (`id`, `nombre`, `descripcion`, `precio_mensual`, `precio_anual`, `max_sucursales`, `max_usuarios`, `max_productos`, `max_pacientes`, `tiene_laboratorio`, `tiene_agenda`, `tiene_reportes`, `tiene_api`, `estado`) VALUES
(1, 'Básico',      'Plan para ópticas pequeñas, 1 sucursal',         29900, 299000,  1,  5,  200,  500,  0, 0, 1, 0, 'activo'),
(2, 'Profesional', 'Plan para ópticas medianas, hasta 3 sucursales', 59900, 599000,  3, 15, 1000, 2000,  1, 1, 1, 0, 'activo'),
(3, 'Enterprise',  'Plan para cadenas, sucursales ilimitadas',        99900, 999000, 99, 99, 9999, 9999,  1, 1, 1, 1, 'activo');

-- ============================================================
-- ROLES DE SISTEMA (empresa_id = NULL)
-- ============================================================
INSERT INTO `roles` (`id`, `empresa_id`, `nombre`, `slug`, `descripcion`, `es_sistema`, `estado`) VALUES
(1, NULL, 'Super Administrador', 'superadmin',      'Acceso total al SaaS',                    1, 'activo'),
(2, NULL, 'Admin Empresa',       'admin_empresa',   'Administrador de empresa',                1, 'activo'),
(3, NULL, 'Jefe de Sucursal',    'jefe_sucursal',   'Gestiona su sucursal',                    1, 'activo'),
(4, NULL, 'Vendedor',            'vendedor',        'Ventas y clientes',                       1, 'activo'),
(5, NULL, 'Optometrista',        'optometrista',    'Recetas, pacientes y agenda',             1, 'activo'),
(6, NULL, 'Cajero',              'cajero',          'Apertura/cierre de caja y pagos',         1, 'activo');

-- ============================================================
-- PERMISOS DEL SISTEMA (formato: modulo.accion)
-- ============================================================
INSERT INTO `permisos` (`modulo`, `nombre`, `descripcion`) VALUES
-- Dashboard
('dashboard',   'dashboard.ver',            'Ver panel principal'),
-- SaaS / SuperAdmin
('saas',        'saas.empresas.ver',         'Ver listado de empresas'),
('saas',        'saas.empresas.crear',       'Crear nuevas empresas'),
('saas',        'saas.empresas.editar',      'Editar empresas'),
('saas',        'saas.empresas.eliminar',    'Eliminar empresas'),
('saas',        'saas.planes.ver',           'Ver planes SaaS'),
('saas',        'saas.planes.gestionar',     'Crear/editar planes'),
('saas',        'saas.licencias.ver',        'Ver licencias'),
('saas',        'saas.licencias.gestionar',  'Crear/editar licencias'),
-- Sucursales
('sucursales',  'sucursales.ver',            'Ver sucursales'),
('sucursales',  'sucursales.crear',          'Crear sucursales'),
('sucursales',  'sucursales.editar',         'Editar sucursales'),
('sucursales',  'sucursales.eliminar',       'Eliminar sucursales'),
-- Usuarios
('usuarios',    'usuarios.ver',              'Ver usuarios'),
('usuarios',    'usuarios.crear',            'Crear usuarios'),
('usuarios',    'usuarios.editar',           'Editar usuarios'),
('usuarios',    'usuarios.eliminar',         'Eliminar usuarios'),
-- Roles
('roles',       'roles.ver',                 'Ver roles y permisos'),
('roles',       'roles.crear',               'Crear roles'),
('roles',       'roles.editar',              'Editar roles'),
('roles',       'roles.eliminar',            'Eliminar roles'),
-- Pacientes
('pacientes',   'pacientes.ver',             'Ver pacientes'),
('pacientes',   'pacientes.crear',           'Crear pacientes'),
('pacientes',   'pacientes.editar',          'Editar pacientes'),
('pacientes',   'pacientes.eliminar',        'Eliminar pacientes'),
-- Recetas
('recetas',     'recetas.ver',               'Ver recetas'),
('recetas',     'recetas.crear',             'Crear recetas'),
('recetas',     'recetas.editar',            'Editar recetas'),
('recetas',     'recetas.imprimir',          'Imprimir/exportar recetas'),
-- Productos
('productos',   'productos.ver',             'Ver productos'),
('productos',   'productos.crear',           'Crear productos'),
('productos',   'productos.editar',          'Editar productos'),
('productos',   'productos.eliminar',        'Eliminar productos'),
-- Stock / Inventario
('stock',       'stock.ver',                 'Ver stock e inventario'),
('stock',       'stock.ajustar',             'Ajustar stock'),
('stock',       'stock.transferir',          'Transferir stock entre sucursales'),
('stock',       'stock.kardex',              'Ver Kardex de Stock'),
-- Ventas
('ventas',      'ventas.ver',                'Ver ventas'),
('ventas',      'ventas.crear',              'Crear ventas (POS)'),
('ventas',      'ventas.editar',             'Editar ventas'),
('ventas',      'ventas.anular',             'Anular ventas'),
('ventas',      'ventas.imprimir',           'Imprimir/exportar ventas'),
('ventas',      'ventas.cotizaciones',       'Ver cotizaciones'),
-- Caja
('caja',        'caja.ver',                  'Ver caja'),
('caja',        'caja.abrir',                'Abrir sesión de caja'),
('caja',        'caja.cerrar',               'Cerrar sesión de caja'),
('caja',        'caja.movimiento',           'Ver/registrar movimientos de caja'),
-- Laboratorio
('laboratorio', 'laboratorio.ver',           'Ver órdenes de laboratorio'),
('laboratorio', 'laboratorio.crear',         'Crear órdenes de laboratorio'),
('laboratorio', 'laboratorio.editar',        'Editar órdenes de laboratorio'),
-- Agenda / Citas
('citas',       'citas.ver',                 'Ver agenda de citas'),
('citas',       'citas.crear',               'Crear citas'),
('citas',       'citas.editar',              'Editar citas'),
-- Reportes
('reportes',    'reportes.ver',              'Ver reportes'),
('reportes',    'reportes.ventas',           'Reporte de Ventas'),
('reportes',    'reportes.stock',            'Reporte de Stock'),
('reportes',    'reportes.caja',             'Reporte de Caja'),
('reportes',    'reportes.exportar',         'Exportar reportes PDF/Excel'),
-- Empresa / Configuración
('empresa',     'empresa.ver',               'Ver configuración empresa'),
('empresa',     'empresa.editar',            'Editar configuración empresa'),
-- Proveedores
('proveedores', 'proveedores.ver',           'Ver proveedores'),
('proveedores', 'proveedores.gestionar',     'Gestionar proveedores'),
-- Otros
('compras',     'compras.ver',               'Ver compras'),
('documentos',  'documentos.ver',            'Ver documentos');

-- ============================================================
-- ASIGNACIÓN DE PERMISOS A ROLES
-- superadmin: todos los permisos
-- ============================================================
INSERT INTO `rol_permisos` (`rol_id`, `permiso_id`, `granted`)
SELECT 1, id, 1 FROM `permisos`;

-- admin_empresa: todo excepto gestión SaaS global
INSERT INTO `rol_permisos` (`rol_id`, `permiso_id`, `granted`)
SELECT 2, id, 1 FROM `permisos`
WHERE `nombre` NOT LIKE 'saas.%';

-- jefe_sucursal: gestión operativa completa de su sucursal
INSERT INTO `rol_permisos` (`rol_id`, `permiso_id`, `granted`)
SELECT 3, id, 1 FROM `permisos`
WHERE `nombre` IN (
  'dashboard.ver',
  'sucursales.ver',
  'usuarios.ver',
  'pacientes.ver','pacientes.crear','pacientes.editar',
  'recetas.ver','recetas.crear','recetas.editar','recetas.imprimir',
  'productos.ver',
  'stock.ver','stock.ajustar','stock.transferir','stock.kardex',
  'ventas.ver','ventas.crear','ventas.editar','ventas.anular','ventas.imprimir','ventas.cotizaciones',
  'caja.ver','caja.abrir','caja.cerrar','caja.movimiento',
  'laboratorio.ver','laboratorio.crear','laboratorio.editar',
  'citas.ver','citas.crear','citas.editar',
  'reportes.ver','reportes.ventas','reportes.stock','reportes.caja','reportes.exportar',
  'proveedores.ver','compras.ver','documentos.ver'
);

-- vendedor: ventas y clientes
INSERT INTO `rol_permisos` (`rol_id`, `permiso_id`, `granted`)
SELECT 4, id, 1 FROM `permisos`
WHERE `nombre` IN (
  'dashboard.ver',
  'pacientes.ver','pacientes.crear','pacientes.editar',
  'recetas.ver','recetas.imprimir',
  'productos.ver','stock.ver',
  'ventas.ver','ventas.crear','ventas.imprimir','ventas.cotizaciones',
  'caja.ver',
  'citas.ver',
  'documentos.ver'
);

-- optometrista: recetas, pacientes, agenda
INSERT INTO `rol_permisos` (`rol_id`, `permiso_id`, `granted`)
SELECT 5, id, 1 FROM `permisos`
WHERE `nombre` IN (
  'dashboard.ver',
  'pacientes.ver','pacientes.crear','pacientes.editar',
  'recetas.ver','recetas.crear','recetas.editar','recetas.imprimir',
  'citas.ver','citas.crear','citas.editar',
  'productos.ver'
);

-- cajero: caja y pagos
INSERT INTO `rol_permisos` (`rol_id`, `permiso_id`, `granted`)
SELECT 6, id, 1 FROM `permisos`
WHERE `nombre` IN (
  'dashboard.ver',
  'caja.ver','caja.abrir','caja.cerrar','caja.movimiento',
  'ventas.ver','ventas.crear','ventas.cotizaciones',
  'pacientes.ver'
);

-- ============================================================
-- EMPRESA DEMO
-- ============================================================
INSERT INTO `empresas` (`id`, `plan_id`, `nombre`, `razon_social`, `rut`, `email`, `telefono`, `direccion`, `ciudad`, `pais`, `moneda`, `color_primario`, `estado`) VALUES
(1, 2, 'Óptica Visión Clara', 'Óptica Visión Clara SpA', '76.123.456-7', 'contacto@visionclaraoptica.cl', '+56 2 2345 6789', 'Av. Providencia 1234, Of. 501', 'Santiago', 'Chile', 'CLP', '#0d6efd', 'activa');

-- ============================================================
-- LICENCIA DEMO
-- ============================================================
INSERT INTO `licencias` (`empresa_id`, `plan_id`, `tipo`, `fecha_inicio`, `fecha_fin`, `monto`, `estado`) VALUES
(1, 2, 'anual', CURDATE(), DATE_ADD(CURDATE(), INTERVAL 1 YEAR), 599000, 'activa');

-- ============================================================
-- SUCURSALES DEMO
-- ============================================================
INSERT INTO `sucursales` (`id`, `empresa_id`, `nombre`, `codigo`, `direccion`, `telefono`, `email`, `horario`, `es_principal`, `estado`) VALUES
(1, 1, 'Casa Matriz - Providencia', 'SUC-001', 'Av. Providencia 1234', '+56 2 2345 6789', 'providencia@visionclaraoptica.cl', 'Lun-Vie 9:00-19:00, Sáb 10:00-14:00', 1, 'activa'),
(2, 1, 'Sucursal Las Condes',       'SUC-002', 'Av. Apoquindo 4500',   '+56 2 2987 6543', 'lascondes@visionclaraoptica.cl',   'Lun-Vie 9:00-19:00, Sáb 10:00-14:00', 0, 'activa');

-- ============================================================
-- USUARIOS
-- superadmin@opticore.com  / password
-- admin@visionclaraoptica.cl / password
-- ============================================================
INSERT INTO `usuarios` (`id`, `empresa_id`, `sucursal_id`, `rol_id`, `nombre`, `apellido`, `email`, `password`, `es_superadmin`, `estado`) VALUES
(1, NULL, NULL, 1, 'Super',    'Admin',      'superadmin@opticore.com',               '$2y$12$D0RvKPdo55Q08FguTG0k1OrNqdRIvM52RKqskJTlynj/oEkIsLQqa', 1, 'activo'),
(2, 1,    1,    2, 'Carlos',   'Mendoza',    'admin@visionclaraoptica.cl',            '$2y$12$D0RvKPdo55Q08FguTG0k1OrNqdRIvM52RKqskJTlynj/oEkIsLQqa', 0, 'activo'),
(3, 1,    1,    3, 'María',    'González',   'jefe.providencia@visionclaraoptica.cl', '$2y$12$D0RvKPdo55Q08FguTG0k1OrNqdRIvM52RKqskJTlynj/oEkIsLQqa', 0, 'activo'),
(4, 1,    1,    4, 'Pedro',    'Ramírez',    'vendedor@visionclaraoptica.cl',         '$2y$12$D0RvKPdo55Q08FguTG0k1OrNqdRIvM52RKqskJTlynj/oEkIsLQqa', 0, 'activo'),
(5, 1,    1,    5, 'Ana',      'Soto',       'optometrista@visionclaraoptica.cl',     '$2y$12$D0RvKPdo55Q08FguTG0k1OrNqdRIvM52RKqskJTlynj/oEkIsLQqa', 0, 'activo'),
(6, 1,    1,    6, 'Luis',     'Herrera',    'cajero@visionclaraoptica.cl',           '$2y$12$D0RvKPdo55Q08FguTG0k1OrNqdRIvM52RKqskJTlynj/oEkIsLQqa', 0, 'activo'),
(7, 1,    2,    3, 'Sofía',    'Vargas',     'jefe.lascondes@visionclaraoptica.cl',   '$2y$12$D0RvKPdo55Q08FguTG0k1OrNqdRIvM52RKqskJTlynj/oEkIsLQqa', 0, 'activo');
-- Contraseña para todos: password

-- ============================================================
-- CATEGORÍAS
-- ============================================================
INSERT INTO `categorias` (`empresa_id`, `nombre`, `descripcion`, `estado`) VALUES
(1, 'Marcos',              'Armazones y monturas',                'activa'),
(1, 'Lentes Oftálmicos',   'Lentes de prescripción',              'activa'),
(1, 'Lentes de Contacto',  'Lentes de contacto blandos y rígidos','activa'),
(1, 'Soluciones',          'Soluciones para lentes de contacto',  'activa'),
(1, 'Accesorios',          'Estuches, cordones, paños, etc.',     'activa'),
(1, 'Servicios',           'Servicios ópticos',                   'activa');

-- ============================================================
-- MARCAS
-- ============================================================
INSERT INTO `marcas` (`empresa_id`, `nombre`, `descripcion`, `estado`) VALUES
(1, 'Ray-Ban',      'Marca premium de gafas',          'activa'),
(1, 'Oakley',       'Gafas deportivas y premium',      'activa'),
(1, 'Silhouette',   'Marcos austríacos de alta gama',  'activa'),
(1, 'Essilor',      'Lentes oftálmicos premium',       'activa'),
(1, 'Hoya',         'Lentes de alta tecnología',       'activa'),
(1, 'Acuvue',       'Lentes de contacto Johnson',      'activa'),
(1, 'Bausch+Lomb',  'Lentes de contacto y soluciones', 'activa'),
(1, 'Sin Marca',    'Productos genéricos',             'activa');

-- ============================================================
-- PROVEEDORES
-- ============================================================
INSERT INTO `proveedores` (`empresa_id`, `nombre`, `rut`, `contacto`, `telefono`, `email`, `tipo`, `estado`) VALUES
(1, 'Distribuidora Óptica Sur',  '77.234.567-8', 'Roberto Pérez',  '+56 2 2111 2222', 'ventas@opticasur.cl',    'proveedor',   'activo'),
(1, 'Laboratorio Visión Total',  '76.345.678-9', 'Carmen López',   '+56 2 2333 4444', 'lab@visiontotal.cl',     'laboratorio', 'activo'),
(1, 'Essilor Chile',             '76.456.789-0', 'Diego Morales',  '+56 2 2555 6666', 'chile@essilor.com',      'ambos',       'activo');

-- ============================================================
-- FORMAS DE PAGO
-- ============================================================
INSERT INTO `formas_pago` (`empresa_id`, `nombre`, `tipo`, `estado`) VALUES
(1, 'Efectivo',              'efectivo',      'activa'),
(1, 'Tarjeta de Débito',     'tarjeta',       'activa'),
(1, 'Tarjeta de Crédito',    'tarjeta',       'activa'),
(1, 'Transferencia Bancaria','transferencia', 'activa'),
(1, 'Crédito Interno',       'credito',       'activa');

-- ============================================================
-- PRODUCTOS
-- ============================================================
INSERT INTO `productos` (`empresa_id`, `categoria_id`, `marca_id`, `proveedor_id`, `sku`, `nombre`, `tipo`, `precio_costo`, `precio_venta`, `impuesto`, `stock_minimo`, `estado`) VALUES
(1, 1, 1, 1, 'RB-3025-001', 'Ray-Ban Aviator RB3025 Dorado',         'marco',     45000, 89990, 0, 3, 'activo'),
(1, 1, 1, 1, 'RB-2140-001', 'Ray-Ban Wayfarer RB2140 Negro',         'marco',     42000, 79990, 0, 3, 'activo'),
(1, 1, 2, 1, 'OAK-OO9102',  'Oakley Holbrook Matte Black',           'marco',     55000, 99990, 0, 2, 'activo'),
(1, 1, 3, 1, 'SIL-5515',    'Silhouette Titan Minimal Art 5515',     'marco',     85000,159990, 0, 2, 'activo'),
(1, 1, 8, 1, 'GEN-METAL-01','Marco Metálico Genérico Plateado',      'marco',      8000, 19990, 0, 5, 'activo'),
(1, 2, 4, 3, 'ESS-VARILUX',  'Lente Varilux Comfort 3.0 Progresivo', 'lente',     35000, 69990, 0, 0, 'activo'),
(1, 2, 5, 1, 'HOY-NULUX',   'Lente Hoya Nulux 1.60 AR',             'lente',     28000, 54990, 0, 0, 'activo'),
(1, 2, 8, 1, 'GEN-LENTE-01','Lente Orgánico 1.50 Antireflejo',      'lente',     12000, 24990, 0, 0, 'activo'),
(1, 3, 6, 1, 'ACU-1DAY-30', 'Acuvue 1-Day Moist 30 unidades',       'lente',      8500, 18990, 0, 5, 'activo'),
(1, 3, 7, 1, 'BL-ULTRA-6',  'Bausch+Lomb Ultra 6 unidades',         'lente',     12000, 24990, 0, 5, 'activo'),
(1, 4, 7, 1, 'BL-SOL-360',  'Bausch+Lomb Solución 360ml',           'solucion',   4500,  9990, 0, 8, 'activo'),
(1, 5, 8, 1, 'ACC-ESTUCHE',  'Estuche Rígido Universal',             'accesorio',  1500,  3990, 0,10, 'activo'),
(1, 5, 8, 1, 'ACC-PANO',    'Paño Microfibra Limpieza',             'accesorio',   500,  1990, 0,20, 'activo'),
(1, 6, 8, 1, 'SRV-EXAM',    'Examen Visual Completo',               'servicio',      0, 15000, 0, 0, 'activo'),
(1, 6, 8, 1, 'SRV-AJUSTE',  'Ajuste y Reparación de Marcos',        'servicio',      0,  5000, 0, 0, 'activo');

-- ============================================================
-- STOCK (sucursal 1 y 2)
-- ============================================================
INSERT INTO `stock` (`empresa_id`, `sucursal_id`, `producto_id`, `cantidad`) VALUES
-- Sucursal 1 (Casa Matriz)
(1, 1,  1, 5), (1, 1,  2, 8), (1, 1,  3, 4), (1, 1,  4, 2), (1, 1,  5,12),
(1, 1,  6, 0), (1, 1,  7, 0), (1, 1,  8, 0), (1, 1,  9,15), (1, 1, 10, 8),
(1, 1, 11,10), (1, 1, 12,20), (1, 1, 13,30), (1, 1, 14, 0), (1, 1, 15, 0),
-- Sucursal 2 (Las Condes)
(1, 2,  1, 3), (1, 2,  2, 5), (1, 2,  3, 2), (1, 2,  4, 1), (1, 2,  5, 8),
(1, 2,  6, 0), (1, 2,  7, 0), (1, 2,  8, 0), (1, 2,  9,10), (1, 2, 10, 5),
(1, 2, 11, 6), (1, 2, 12,15), (1, 2, 13,20), (1, 2, 14, 0), (1, 2, 15, 0);

-- ============================================================
-- PACIENTES DEMO
-- ============================================================
INSERT INTO `pacientes` (`empresa_id`, `sucursal_id`, `nombre`, `apellido`, `rut`, `fecha_nacimiento`, `genero`, `telefono`, `email`, `ciudad`, `estado`) VALUES
(1, 1, 'Juan',      'Pérez Silva',    '12.345.678-9', '1985-03-15', 'M', '+56 9 8765 4321', 'juan.perez@gmail.com',    'Santiago',    'activo'),
(1, 1, 'María',     'López Rojas',    '13.456.789-0', '1990-07-22', 'F', '+56 9 7654 3210', 'maria.lopez@gmail.com',   'Santiago',    'activo'),
(1, 1, 'Carlos',    'Martínez Díaz',  '14.567.890-1', '1978-11-08', 'M', '+56 9 6543 2109', 'carlos.m@hotmail.com',    'Providencia', 'activo'),
(1, 1, 'Ana',       'García Muñoz',   '15.678.901-2', '1995-04-30', 'F', '+56 9 5432 1098', 'ana.garcia@gmail.com',    'Las Condes',  'activo'),
(1, 2, 'Roberto',   'Sánchez Torres', '16.789.012-3', '1982-09-12', 'M', '+56 9 4321 0987', 'roberto.s@yahoo.com',     'Vitacura',    'activo'),
(1, 2, 'Claudia',   'Fernández Vega', '17.890.123-4', '1988-01-25', 'F', '+56 9 3210 9876', 'claudia.f@gmail.com',     'Las Condes',  'activo'),
(1, 1, 'Diego',     'Morales Pinto',  '18.901.234-5', '1972-06-18', 'M', '+56 9 2109 8765', 'diego.morales@gmail.com', 'Ñuñoa',       'activo'),
(1, 1, 'Valentina', 'Castro Reyes',   '19.012.345-6', '2000-12-05', 'F', '+56 9 1098 7654', 'vale.castro@gmail.com',   'Santiago',    'activo');

-- ============================================================
-- RECETAS DEMO
-- ============================================================
INSERT INTO `recetas` (`empresa_id`, `sucursal_id`, `paciente_id`, `usuario_id`, `fecha`, `vigencia`, `tipo`, `od_esfera`, `od_cilindro`, `od_eje`, `od_adicion`, `od_dp`, `od_av`, `oi_esfera`, `oi_cilindro`, `oi_eje`, `oi_adicion`, `oi_dp`, `oi_av`, `dp_total`, `observaciones`, `estado`) VALUES
(1, 1, 1, 5, DATE_SUB(CURDATE(), INTERVAL 30 DAY),  DATE_ADD(CURDATE(), INTERVAL 335 DAY), 'lejos',      -2.50, -0.75, 180, NULL, 32.0, '20/30', -2.00, -0.50, 175, NULL, 31.5, '20/25', 63.5, 'Paciente con miopía moderada', 'activa'),
(1, 1, 2, 5, DATE_SUB(CURDATE(), INTERVAL 15 DAY),  DATE_ADD(CURDATE(), INTERVAL 350 DAY), 'progresivo', -1.00, -0.25,  90, 2.00, 31.0, '20/20', -1.25, -0.50,  85, 2.00, 30.5, '20/20', 61.5, 'Primera vez con progresivos', 'activa'),
(1, 1, 3, 5, DATE_SUB(CURDATE(), INTERVAL 60 DAY),  DATE_ADD(CURDATE(), INTERVAL 305 DAY), 'lejos',      -4.00, -1.00, 170, NULL, 33.0, '20/40', -3.75, -0.75, 165, NULL, 32.0, '20/30', 65.0, 'Miopía alta, recomendar lentes 1.67', 'activa'),
(1, 1, 4, 5, DATE_SUB(CURDATE(), INTERVAL  5 DAY),  DATE_ADD(CURDATE(), INTERVAL 360 DAY), 'cerca',       1.50,  0.00,   0, NULL, 30.0, '20/20',  1.75,  0.00,   0, NULL, 30.0, '20/20', 60.0, 'Hipermetropía leve', 'activa'),
(1, 2, 5, 5, DATE_SUB(CURDATE(), INTERVAL 45 DAY),  DATE_ADD(CURDATE(), INTERVAL 320 DAY), 'lejos',      -1.50, -0.50, 160, NULL, 32.5, '20/25', -1.75, -0.25, 155, NULL, 31.5, '20/25', 64.0, NULL, 'activa'),
(1, 1, 7, 5, DATE_SUB(CURDATE(), INTERVAL 90 DAY),  DATE_ADD(CURDATE(), INTERVAL 275 DAY), 'bifocal',    -2.00, -0.75, 180, 2.50, 33.0, '20/30', -2.25, -0.50, 175, 2.50, 32.0, '20/30', 65.0, 'Paciente mayor, bifocal recomendado', 'activa');

-- ============================================================
-- VENTAS DEMO
-- ============================================================
INSERT INTO `ventas` (`empresa_id`, `sucursal_id`, `usuario_id`, `paciente_id`, `correlativo`, `fecha`, `subtotal`, `descuento`, `impuesto`, `total`, `estado`) VALUES
(1, 1, 4, 1, 'V-001-0001', DATE_SUB(NOW(), INTERVAL 20 DAY), 109980,  0,    0, 109980, 'confirmada'),
(1, 1, 4, 2, 'V-001-0002', DATE_SUB(NOW(), INTERVAL 15 DAY), 139980,  0,    0, 139980, 'confirmada'),
(1, 1, 4, 3, 'V-001-0003', DATE_SUB(NOW(), INTERVAL 10 DAY),  89990,  5000, 0,  84990, 'confirmada'),
(1, 1, 4, 4, 'V-001-0004', DATE_SUB(NOW(), INTERVAL  5 DAY),  24990,  0,    0,  24990, 'confirmada'),
(1, 1, 4, 1, 'V-001-0005', DATE_SUB(NOW(), INTERVAL  2 DAY),  15000,  0,    0,  15000, 'confirmada'),
(1, 2, 7, 5, 'V-002-0001', DATE_SUB(NOW(), INTERVAL 12 DAY),  99990,  0,    0,  99990, 'confirmada'),
(1, 2, 7, 6, 'V-002-0002', DATE_SUB(NOW(), INTERVAL  8 DAY),  54990,  0,    0,  54990, 'confirmada'),
(1, 1, 4, 7, 'V-001-0006', DATE_SUB(NOW(), INTERVAL  1 DAY), 169980, 10000, 0, 159980, 'confirmada'),
(1, 1, 4, 8, 'V-001-0007', NOW(),                             18990,  0,    0,  18990, 'cotizacion');

-- ============================================================
-- VENTA ITEMS DEMO
-- ============================================================
INSERT INTO `venta_items` (`venta_id`, `producto_id`, `nombre_producto`, `cantidad`, `precio_unitario`, `descuento`, `impuesto`, `subtotal`) VALUES
(1, 1, 'Ray-Ban Aviator RB3025 Dorado',  1, 89990, 0, 0,  89990),
(1, 7, 'Lente Hoya Nulux 1.60 AR',       1, 54990, 0, 0,  54990),
(2, 3, 'Oakley Holbrook Matte Black',    1, 99990, 0, 0,  99990),
(2, 6, 'Lente Varilux Comfort 3.0',      1, 69990, 0, 0,  69990),
(3, 2, 'Ray-Ban Wayfarer RB2140 Negro',  1, 79990, 5000, 0, 74990),
(4, 9, 'Acuvue 1-Day Moist 30 unidades', 1, 18990, 0, 0,  18990),
(5, 14,'Examen Visual Completo',         1, 15000, 0, 0,  15000),
(6, 3, 'Oakley Holbrook Matte Black',    1, 99990, 0, 0,  99990),
(7, 7, 'Lente Hoya Nulux 1.60 AR',      1, 54990, 0, 0,  54990),
(8, 4, 'Silhouette Titan Minimal Art',   1,159990,10000, 0,149990),
(8, 6, 'Lente Varilux Comfort 3.0',      1, 69990, 0, 0,  69990),
(9, 9, 'Acuvue 1-Day Moist 30 unidades', 1, 18990, 0, 0,  18990);

-- ============================================================
-- VENTA PAGOS DEMO
-- ============================================================
INSERT INTO `venta_pagos` (`venta_id`, `forma_pago_id`, `monto`) VALUES
(1, 2, 109980),
(2, 3, 139980),
(3, 1,  84990),
(4, 1,  24990),
(5, 1,  15000),
(6, 2,  99990),
(7, 4,  54990),
(8, 3, 159980);

-- ============================================================
-- CAJA SESIONES DEMO
-- ============================================================
INSERT INTO `caja_sesiones` (`empresa_id`, `sucursal_id`, `usuario_id`, `correlativo`, `fecha_apertura`, `monto_apertura`, `fecha_cierre`, `monto_cierre_real`, `monto_cierre_sistema`, `diferencia`, `estado`) VALUES
(1, 1, 6, 'C-001-0001', DATE_SUB(NOW(), INTERVAL 3 DAY), 50000, DATE_SUB(NOW(), INTERVAL 3 DAY) + INTERVAL 9 HOUR, 185000, 185000,    0, 'cerrada'),
(1, 1, 6, 'C-001-0002', DATE_SUB(NOW(), INTERVAL 2 DAY), 50000, DATE_SUB(NOW(), INTERVAL 2 DAY) + INTERVAL 9 HOUR, 220000, 220000,    0, 'cerrada'),
(1, 1, 6, 'C-001-0003', DATE_SUB(NOW(), INTERVAL 1 DAY), 50000, DATE_SUB(NOW(), INTERVAL 1 DAY) + INTERVAL 9 HOUR, 175000, 174000, 1000, 'cerrada'),
(1, 1, 6, 'C-001-0004', NOW(),                           50000, NULL, NULL, NULL, NULL, 'abierta'),
(1, 2, 7, 'C-002-0001', DATE_SUB(NOW(), INTERVAL 1 DAY), 30000, DATE_SUB(NOW(), INTERVAL 1 DAY) + INTERVAL 9 HOUR, 154980, 154980,    0, 'cerrada'),
(1, 2, 7, 'C-002-0002', NOW(),                           30000, NULL, NULL, NULL, NULL, 'abierta');

-- ============================================================
-- CAJA MOVIMIENTOS DEMO
-- ============================================================
INSERT INTO `caja_movimientos` (`empresa_id`, `sucursal_id`, `sesion_id`, `usuario_id`, `tipo`, `concepto`, `monto`, `forma_pago_id`, `referencia_tipo`, `referencia_id`) VALUES
(1, 1, 4, 6, 'ingreso', 'Venta V-001-0005', 15000, 1, 'venta', 5),
(1, 1, 4, 6, 'egreso',  'Pago servicio limpieza', 8000, 1, NULL, NULL);

-- ============================================================
-- ÓRDENES DE LABORATORIO DEMO
-- ============================================================
INSERT INTO `ordenes_laboratorio` (`empresa_id`, `sucursal_id`, `venta_id`, `receta_id`, `paciente_id`, `proveedor_id`, `usuario_id`, `correlativo`, `estado`, `fecha_recepcion`, `fecha_estimada`, `descripcion`) VALUES
(1, 1, 1, 1, 1, 2, 3, 'OL-001-0001', 'entregado',  DATE_SUB(CURDATE(), INTERVAL 18 DAY), DATE_SUB(CURDATE(), INTERVAL 10 DAY), 'Lentes progresivos Varilux con AR'),
(1, 1, 2, 2, 2, 2, 3, 'OL-001-0002', 'listo',      DATE_SUB(CURDATE(), INTERVAL 13 DAY), DATE_SUB(CURDATE(), INTERVAL  5 DAY), 'Lentes bifocales Hoya 1.60'),
(1, 1, 8, 6, 7, 2, 3, 'OL-001-0003', 'en_proceso', DATE_SUB(CURDATE(), INTERVAL  1 DAY), DATE_ADD(CURDATE(), INTERVAL  5 DAY), 'Lentes Varilux alta graduación');

-- ============================================================
-- CITAS DEMO
-- ============================================================
INSERT INTO `citas` (`empresa_id`, `sucursal_id`, `paciente_id`, `usuario_id`, `fecha`, `hora`, `duracion`, `tipo`, `estado`, `observaciones`) VALUES
(1, 1, 1, 5, CURDATE(),                          '10:00:00', 30, 'optometria', 'atendida',  'Control anual'),
(1, 1, 2, 5, CURDATE(),                          '11:00:00', 45, 'optometria', 'confirmada','Primera consulta progresivos'),
(1, 1, 3, 5, DATE_ADD(CURDATE(), INTERVAL 1 DAY),'09:30:00', 30, 'control',    'pendiente', 'Control post-adaptación'),
(1, 1, 4, 5, DATE_ADD(CURDATE(), INTERVAL 1 DAY),'10:30:00', 30, 'optometria', 'pendiente', NULL),
(1, 1, 7, 5, DATE_ADD(CURDATE(), INTERVAL 2 DAY),'15:00:00', 30, 'entrega',    'pendiente', 'Entrega lentes bifocales'),
(1, 2, 5, 7, DATE_ADD(CURDATE(), INTERVAL 1 DAY),'09:00:00', 30, 'optometria', 'pendiente', NULL),
(1, 2, 6, 7, DATE_ADD(CURDATE(), INTERVAL 3 DAY),'11:00:00', 30, 'control',    'pendiente', 'Control lentes de contacto');

-- ============================================================
-- MOVIMIENTOS DE STOCK DEMO
-- ============================================================
INSERT INTO `movimientos_stock` (`empresa_id`, `sucursal_id`, `producto_id`, `usuario_id`, `tipo`, `cantidad`, `cantidad_anterior`, `cantidad_nueva`, `costo_unitario`, `referencia_tipo`, `referencia_id`, `observaciones`) VALUES
(1, 1, 1, 2, 'entrada',  5, 0,  5, 45000, 'compra', NULL, 'Ingreso inicial inventario'),
(1, 1, 2, 2, 'entrada',  8, 0,  8, 42000, 'compra', NULL, 'Ingreso inicial inventario'),
(1, 1, 3, 2, 'entrada',  4, 0,  4, 55000, 'compra', NULL, 'Ingreso inicial inventario'),
(1, 1, 9, 2, 'entrada', 15, 0, 15,  8500, 'compra', NULL, 'Ingreso inicial inventario'),
(1, 1, 1, 4, 'venta',    1, 5,  4, 45000, 'venta',  1,    'Venta V-001-0001'),
(1, 1, 3, 4, 'venta',    1, 4,  3, 55000, 'venta',  2,    'Venta V-001-0002'),
(1, 1, 2, 4, 'venta',    1, 8,  7, 42000, 'venta',  3,    'Venta V-001-0003'),
(1, 1, 9, 4, 'venta',    1,15, 14,  8500, 'venta',  4,    'Venta V-001-0004');

-- ============================================================
-- FIN DE SEEDS
-- ============================================================
-- Credenciales de acceso:
-- superadmin@opticore.com              | password  (Superadmin SaaS)
-- admin@visionclaraoptica.cl           | password  (Admin Empresa)
-- jefe.providencia@visionclaraoptica.cl| password  (Jefe Sucursal 1)
-- vendedor@visionclaraoptica.cl        | password  (Vendedor)
-- optometrista@visionclaraoptica.cl    | password  (Optometrista)
-- cajero@visionclaraoptica.cl          | password  (Cajero)
-- jefe.lascondes@visionclaraoptica.cl  | password  (Jefe Sucursal 2)
