-- ============================================================
-- OptiCore SaaS - Migration 002: Audit Logs Permission
-- Run after 001_new_modules_permissions.sql
-- Adds audit_logs.ver permission and assigns to admin roles
-- ============================================================

USE `opticore`;

-- ── Insert audit_logs permission ──────────────────────────────
INSERT IGNORE INTO `permisos` (`modulo`, `nombre`, `descripcion`) VALUES
('audit_logs', 'audit_logs.ver', 'Ver logs de auditoría del sistema');

-- ── Assign to superadmin (rol_id=1) ──────────────────────────
INSERT IGNORE INTO `rol_permisos` (`rol_id`, `permiso_id`, `granted`)
SELECT 1, id, 1 FROM `permisos` WHERE `nombre` = 'audit_logs.ver';

-- ── Assign to admin_empresa (rol_id=2) ───────────────────────
INSERT IGNORE INTO `rol_permisos` (`rol_id`, `permiso_id`, `granted`)
SELECT 2, id, 1 FROM `permisos` WHERE `nombre` = 'audit_logs.ver';
