-- ============================================================
-- OptiCore SaaS - Fix: Corrección de Hashes de Contraseña
-- ============================================================
-- PROBLEMA: El hash '$2y$12$92IXUNpkjO0rOQ5byMi...' en seeds.sql
-- era inválido (cost 10 copiado y cambiado a 12 manualmente).
-- password_verify('password', hash_invalido) retornaba FALSE.
--
-- SOLUCIÓN: Actualizar todos los usuarios con el hash correcto
-- generado con: password_hash('password', PASSWORD_BCRYPT, ['cost'=>12])
--
-- Hash válido para "password" con cost 12:
-- $2y$12$D0RvKPdo55Q08FguTG0k1OrNqdRIvM52RKqskJTlynj/oEkIsLQqa
--
-- INSTRUCCIONES:
-- 1. Abrir phpMyAdmin → seleccionar base de datos 'opticore'
-- 2. Ir a la pestaña SQL
-- 3. Pegar y ejecutar este script
-- ============================================================

USE `opticore`;

-- ── Actualizar contraseñas de todos los usuarios de prueba ────
UPDATE `usuarios`
SET `password` = '$2y$12$D0RvKPdo55Q08FguTG0k1OrNqdRIvM52RKqskJTlynj/oEkIsLQqa'
WHERE `email` IN (
    'superadmin@opticore.com',
    'admin@visionclaraoptica.cl',
    'jefe.providencia@visionclaraoptica.cl',
    'vendedor@visionclaraoptica.cl',
    'optometrista@visionclaraoptica.cl',
    'cajero@visionclaraoptica.cl',
    'jefe.lascondes@visionclaraoptica.cl'
);

-- ── Asegurar que todos los usuarios estén activos ─────────────
UPDATE `usuarios`
SET `estado` = 'activo'
WHERE `email` IN (
    'superadmin@opticore.com',
    'admin@visionclaraoptica.cl',
    'jefe.providencia@visionclaraoptica.cl',
    'vendedor@visionclaraoptica.cl',
    'optometrista@visionclaraoptica.cl',
    'cajero@visionclaraoptica.cl',
    'jefe.lascondes@visionclaraoptica.cl'
);

-- ── Asegurar que la empresa demo esté activa ──────────────────
UPDATE `empresas`
SET `estado` = 'activa'
WHERE `id` = 1;

-- ── Insertar nuevo Super Admin: Josue Pazmino ─────────────────
-- Email corregido: josuepazmio@gmailc,om → josuepazmino@gmail.com
-- Contraseña: natanael1
INSERT INTO `usuarios`
    (`empresa_id`, `sucursal_id`, `rol_id`, `nombre`, `apellido`, `email`, `password`, `es_superadmin`, `estado`)
VALUES
    (NULL, NULL, 1, 'Josue', 'Pazmino', 'josuepazmino@gmail.com',
     '$2y$12$BWCMYD3tNxkmJGB0HebsJu7MQO/kpYJMFKvpd401rGyo7op3.Ji2q',
     1, 'activo')
ON DUPLICATE KEY UPDATE
    `nombre`       = 'Josue',
    `apellido`     = 'Pazmino',
    `password`     = '$2y$12$BWCMYD3tNxkmJGB0HebsJu7MQO/kpYJMFKvpd401rGyo7op3.Ji2q',
    `es_superadmin`= 1,
    `estado`       = 'activo';

-- ── Verificación: mostrar usuarios actualizados ───────────────
SELECT
    id,
    email,
    estado,
    es_superadmin,
    LEFT(password, 7) AS hash_prefix,
    CASE
        WHEN LEFT(password, 7) = '$2y$12' THEN 'Hash válido (bcrypt cost 12)'
        ELSE 'HASH INVÁLIDO - revisar'
    END AS hash_status
FROM `usuarios`
ORDER BY id;

-- ── Resultado esperado ────────────────────────────────────────
-- Todos los usuarios deben mostrar:
--   estado      = activo
--   hash_prefix = $2y$12
--   hash_status = Hash válido (bcrypt cost 12)
--
-- Credenciales de acceso (contraseña: password):
--   superadmin@opticore.com               → Super Admin
--   admin@visionclaraoptica.cl            → Admin Empresa
--   jefe.providencia@visionclaraoptica.cl → Jefe Sucursal 1
--   vendedor@visionclaraoptica.cl         → Vendedor
--   optometrista@visionclaraoptica.cl     → Optometrista
--   cajero@visionclaraoptica.cl           → Cajero
--   jefe.lascondes@visionclaraoptica.cl   → Jefe Sucursal 2
-- ============================================================
