<?php /* Vista: Ver Venta */ ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h4 class="mb-0 fw-bold">
        <i class="bi bi-receipt text-primary me-2"></i>Venta <?= clean($venta['correlativo']) ?>
    </h4>
    <div class="d-flex gap-2">
        <a href="<?= BASE_URL ?>/ventas/<?= $venta['id'] ?>/print" class="btn btn-outline-dark btn-sm" target="_blank">
            <i class="bi bi-printer me-1"></i>Imprimir
        </a>
        <?php if ($venta['estado'] !== 'anulada' && can('ventas.anular')): ?>
        <form method="POST" action="<?= BASE_URL ?>/ventas/<?= $venta['id'] ?>/anular"
              data-confirm="¿Anular esta venta? Se revertirá el stock.">
            <?= csrf_field() ?>
            <button type="submit" class="btn btn-outline-danger btn-sm">
                <i class="bi bi-x-circle me-1"></i>Anular
            </button>
        </form>
        <?php endif; ?>
        <a href="<?= BASE_URL ?>/ventas" class="btn btn-outline-secondary btn-sm">
            <i class="bi bi-arrow-left me-1"></i>Volver
        </a>
    </div>
</div>

<div class="row g-3">
    <!-- Detalle de items -->
    <div class="col-lg-8">
        <div class="card border-0 shadow-sm mb-3">
            <div class="card-header bg-transparent d-flex justify-content-between align-items-center">
                <h6 class="mb-0 fw-semibold">Detalle de Productos</h6>
                <?= statusBadge($venta['estado']) ?>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-sm align-middle mb-0">
                        <thead class="table-light">
                            <tr>
                                <th>Producto</th>
                                <th class="text-center">Cant.</th>
                                <th class="text-end">Precio</th>
                                <th class="text-center">Desc.%</th>
                                <th class="text-end">Subtotal</th>
                            </tr>
                        </thead>
                        <tbody>
                        <?php foreach ($items as $item): ?>
                        <tr>
                            <td class="small fw-medium"><?= clean($item['producto_nombre']) ?></td>
                            <td class="text-center small"><?= $item['cantidad'] ?></td>
                            <td class="text-end small"><?= formatMoney($item['precio_unitario'], Auth::moneda()) ?></td>
                            <td class="text-center small"><?= $item['descuento'] > 0 ? $item['descuento'] . '%' : '-' ?></td>
                            <td class="text-end small fw-medium"><?= formatMoney($item['subtotal'], Auth::moneda()) ?></td>
                        </tr>
                        <?php endforeach; ?>
                        </tbody>
                        <tfoot class="table-light">
                            <tr>
                                <td colspan="4" class="text-end small">Subtotal:</td>
                                <td class="text-end small"><?= formatMoney($venta['subtotal'], Auth::moneda()) ?></td>
                            </tr>
                            <?php if ($venta['descuento'] > 0): ?>
                            <tr>
                                <td colspan="4" class="text-end small text-danger">Descuento:</td>
                                <td class="text-end small text-danger">-<?= formatMoney($venta['descuento'], Auth::moneda()) ?></td>
                            </tr>
                            <?php endif; ?>
                            <tr>
                                <td colspan="4" class="text-end fw-bold">TOTAL:</td>
                                <td class="text-end fw-bold text-primary"><?= formatMoney($venta['total'], Auth::moneda()) ?></td>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>

        <!-- Pagos -->
        <div class="card border-0 shadow-sm">
            <div class="card-header bg-transparent"><h6 class="mb-0 fw-semibold">Pagos Registrados</h6></div>
            <div class="card-body p-0">
                <table class="table table-sm mb-0">
                    <thead class="table-light">
                        <tr><th>Método</th><th class="text-end">Monto</th></tr>
                    </thead>
                    <tbody>
                    <?php foreach ($pagos as $pago): ?>
                    <tr>
                        <td class="small">
                            <i class="bi bi-<?= $pago['metodo'] === 'efectivo' ? 'cash' : 'credit-card' ?> me-1"></i>
                            <?= ucfirst(str_replace('_', ' ', $pago['metodo'])) ?>
                        </td>
                        <td class="text-end small fw-medium"><?= formatMoney($pago['monto'], Auth::moneda()) ?></td>
                    </tr>
                    <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Info lateral -->
    <div class="col-lg-4">
        <div class="card border-0 shadow-sm mb-3">
            <div class="card-header bg-transparent"><h6 class="mb-0 fw-semibold">Información</h6></div>
            <div class="card-body small">
                <dl class="row mb-0">
                    <dt class="col-5 text-muted">Correlativo</dt>
                    <dd class="col-7 font-monospace"><?= clean($venta['correlativo']) ?></dd>

                    <dt class="col-5 text-muted">Fecha</dt>
                    <dd class="col-7"><?= formatDateTime($venta['created_at']) ?></dd>

                    <dt class="col-5 text-muted">Sucursal</dt>
                    <dd class="col-7"><?= clean($venta['sucursal_nombre']) ?></dd>

                    <dt class="col-5 text-muted">Vendedor</dt>
                    <dd class="col-7"><?= clean($venta['usuario_nombre'] ?? '-') ?></dd>

                    <dt class="col-5 text-muted">Documento</dt>
                    <dd class="col-7"><?= ucfirst(str_replace('_', ' ', $venta['tipo_documento'] ?? '-')) ?></dd>

                    <?php if ($venta['paciente_nombre']): ?>
                    <dt class="col-5 text-muted">Paciente</dt>
                    <dd class="col-7">
                        <a href="<?= BASE_URL ?>/pacientes/<?= $venta['paciente_id'] ?>" class="text-decoration-none">
                            <?= clean($venta['paciente_nombre']) ?>
                        </a>
                    </dd>
                    <?php endif; ?>

                    <?php if ($venta['observaciones']): ?>
                    <dt class="col-5 text-muted">Notas</dt>
                    <dd class="col-7"><?= clean($venta['observaciones']) ?></dd>
                    <?php endif; ?>
                </dl>
            </div>
        </div>

        <?php if ($venta['estado'] === 'anulada' && $venta['motivo_anulacion']): ?>
        <div class="alert alert-danger small">
            <strong>Motivo de anulación:</strong> <?= clean($venta['motivo_anulacion']) ?>
        </div>
        <?php endif; ?>
    </div>
</div>
