<?php /* Vista: Sucursales */ ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h4 class="mb-0 fw-bold"><i class="bi bi-shop text-primary me-2"></i>Sucursales</h4>
    <?php if (can('sucursales.crear')): ?>
    <a href="<?= BASE_URL ?>/sucursales/create" class="btn btn-primary">
        <i class="bi bi-plus-lg me-1"></i>Nueva Sucursal
    </a>
    <?php endif; ?>
</div>

<div class="card border-0 shadow-sm">
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-hover align-middle mb-0">
                <thead class="table-light">
                    <tr>
                        <th>Nombre</th>
                        <?php if (Auth::isSuperAdmin()): ?>
                        <th>Empresa</th>
                        <?php endif; ?>
                        <th>Código</th>
                        <th>Teléfono</th>
                        <th>Email</th>
                        <th>Estado</th>
                        <th class="text-end">Acciones</th>
                    </tr>
                </thead>
                <tbody>
                <?php foreach ($sucursales as $s): ?>
                <tr>
                    <td>
                        <span class="fw-semibold"><?= clean($s['nombre']) ?></span>
                        <?php if ($s['es_principal']): ?>
                        <span class="badge bg-primary ms-1" style="font-size:10px">Principal</span>
                        <?php endif; ?>
                        <?php if ($s['direccion']): ?>
                        <div class="text-muted small"><?= clean($s['direccion']) ?></div>
                        <?php endif; ?>
                    </td>
                    <?php if (Auth::isSuperAdmin()): ?>
                    <td class="text-muted small">
                        <i class="bi bi-building me-1"></i><?= clean($s['empresa_nombre'] ?? '-') ?>
                    </td>
                    <?php endif; ?>
                    <td class="text-muted small"><?= clean($s['codigo'] ?? '-') ?></td>
                    <td class="text-muted small"><?= clean($s['telefono'] ?? '-') ?></td>
                    <td class="text-muted small"><?= clean($s['email'] ?? '-') ?></td>
                    <td><?= statusBadge($s['estado']) ?></td>
                    <td class="text-end">
                        <div class="btn-group btn-group-sm">
                            <?php if (can('sucursales.editar')): ?>
                            <a href="<?= BASE_URL ?>/sucursales/<?= $s['id'] ?>/edit" class="btn btn-outline-primary">
                                <i class="bi bi-pencil"></i>
                            </a>
                            <?php endif; ?>
                            <?php if (can('sucursales.eliminar') && !$s['es_principal']): ?>
                            <form method="POST" action="<?= BASE_URL ?>/sucursales/<?= $s['id'] ?>/delete"
                                  data-confirm="¿Eliminar sucursal?">
                                <?= csrf_field() ?>
                                <button type="submit" class="btn btn-outline-danger"><i class="bi bi-trash"></i></button>
                            </form>
                            <?php endif; ?>
                        </div>
                    </td>
                </tr>
                <?php endforeach; ?>
                <?php if (empty($sucursales)): ?>
                <tr><td colspan="<?= Auth::isSuperAdmin() ? 7 : 6 ?>" class="text-center text-muted py-4">No hay sucursales registradas.</td></tr>
                <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
