<?php /* Vista: Crear Rol */ ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h4 class="mb-0 fw-bold"><i class="bi bi-shield-plus text-primary me-2"></i>Nuevo Rol</h4>
    <a href="<?= BASE_URL ?>/roles" class="btn btn-outline-secondary btn-sm">
        <i class="bi bi-arrow-left me-1"></i>Volver
    </a>
</div>

<div class="row justify-content-center">
<div class="col-lg-7">
<div class="card border-0 shadow-sm">
<div class="card-body p-4">
<form method="POST" action="<?= BASE_URL ?>/roles">
    <?= csrf_field() ?>
    <div class="row g-3">
        <div class="col-md-7">
            <label class="form-label fw-medium">Nombre <span class="text-danger">*</span></label>
            <input type="text" name="nombre" class="form-control" value="<?= clean(post('nombre')) ?>" required autofocus>
        </div>
        <div class="col-md-5">
            <label class="form-label fw-medium">Slug <span class="text-danger">*</span></label>
            <input type="text" name="slug" class="form-control" value="<?= clean(post('slug')) ?>"
                   required pattern="[a-z0-9_\-]+" placeholder="mi-rol">
            <div class="form-text">Solo minúsculas, guiones y números.</div>
        </div>
        <div class="col-12">
            <label class="form-label fw-medium">Descripción</label>
            <textarea name="descripcion" class="form-control" rows="2"><?= clean(post('descripcion')) ?></textarea>
        </div>
        <div class="col-12 d-flex gap-2 justify-content-end mt-2">
            <a href="<?= BASE_URL ?>/roles" class="btn btn-outline-secondary">Cancelar</a>
            <button type="submit" class="btn btn-primary px-4">
                <i class="bi bi-check-lg me-1"></i>Crear Rol
            </button>
        </div>
    </div>
</form>
</div>
</div>
</div>
</div>

<script>
// Auto-generar slug desde nombre
document.querySelector('[name="nombre"]').addEventListener('input', function () {
    const slug = document.querySelector('[name="slug"]');
    if (!slug.dataset.manual) {
        slug.value = this.value.toLowerCase()
            .normalize('NFD').replace(/[\u0300-\u036f]/g, '')
            .replace(/[^a-z0-9]+/g, '-').replace(/^-|-$/g, '');
    }
});
document.querySelector('[name="slug"]').addEventListener('input', function () {
    this.dataset.manual = '1';
});
</script>
