<?php /* Vista: Reporte de Ventas */ ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h4 class="mb-0 fw-bold"><i class="bi bi-receipt text-primary me-2"></i>Reporte de Ventas</h4>
    <a href="<?= BASE_URL ?>/reportes" class="btn btn-outline-secondary btn-sm">
        <i class="bi bi-arrow-left me-1"></i>Reportes
    </a>
</div>

<!-- Filtros -->
<div class="card border-0 shadow-sm mb-4">
    <div class="card-body">
        <form method="GET" action="<?= BASE_URL ?>/reportes/ventas" class="row g-2 align-items-end">
            <div class="col-sm-6 col-md-3">
                <label class="form-label small fw-medium">Desde</label>
                <input type="date" name="desde" class="form-control form-control-sm"
                       value="<?= clean(get('desde', date('Y-m-01'))) ?>">
            </div>
            <div class="col-sm-6 col-md-3">
                <label class="form-label small fw-medium">Hasta</label>
                <input type="date" name="hasta" class="form-control form-control-sm"
                       value="<?= clean(get('hasta', date('Y-m-d'))) ?>">
            </div>
            <div class="col-sm-6 col-md-3">
                <label class="form-label small fw-medium">Sucursal</label>
                <select name="sucursal_id" class="form-select form-select-sm">
                    <option value="">Todas</option>
                    <?php foreach ($sucursales as $s): ?>
                    <option value="<?= $s['id'] ?>" <?= get('sucursal_id') == $s['id'] ? 'selected' : '' ?>>
                        <?= clean($s['nombre']) ?>
                    </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="col-sm-6 col-md-3">
                <label class="form-label small fw-medium">Agrupar por</label>
                <select name="agrupar" class="form-select form-select-sm">
                    <option value="dia"      <?= get('agrupar', 'dia') === 'dia'      ? 'selected' : '' ?>>Día</option>
                    <option value="semana"   <?= get('agrupar') === 'semana'   ? 'selected' : '' ?>>Semana</option>
                    <option value="mes"      <?= get('agrupar') === 'mes'      ? 'selected' : '' ?>>Mes</option>
                    <option value="producto" <?= get('agrupar') === 'producto' ? 'selected' : '' ?>>Producto</option>
                    <option value="usuario"  <?= get('agrupar') === 'usuario'  ? 'selected' : '' ?>>Vendedor</option>
                </select>
            </div>
            <div class="col-12 d-flex gap-2">
                <button type="submit" class="btn btn-primary btn-sm">
                    <i class="bi bi-search me-1"></i>Generar Reporte
                </button>
                <a href="<?= BASE_URL ?>/reportes/ventas/export?<?= http_build_query($_GET) ?>"
                   class="btn btn-outline-success btn-sm">
                    <i class="bi bi-file-earmark-excel me-1"></i>Exportar CSV
                </a>
            </div>
        </form>
    </div>
</div>

<!-- KPIs -->
<div class="row g-3 mb-4">
    <div class="col-sm-6 col-xl-3">
        <div class="card border-0 shadow-sm text-center py-3">
            <div class="fs-3 fw-bold text-success"><?= formatMoney($kpis['total'] ?? 0, Auth::moneda()) ?></div>
            <div class="text-muted small">Total Ventas</div>
        </div>
    </div>
    <div class="col-sm-6 col-xl-3">
        <div class="card border-0 shadow-sm text-center py-3">
            <div class="fs-3 fw-bold text-primary"><?= $kpis['cantidad'] ?? 0 ?></div>
            <div class="text-muted small">N° Transacciones</div>
        </div>
    </div>
    <div class="col-sm-6 col-xl-3">
        <div class="card border-0 shadow-sm text-center py-3">
            <div class="fs-3 fw-bold text-info"><?= formatMoney($kpis['promedio'] ?? 0, Auth::moneda()) ?></div>
            <div class="text-muted small">Ticket Promedio</div>
        </div>
    </div>
    <div class="col-sm-6 col-xl-3">
        <div class="card border-0 shadow-sm text-center py-3">
            <div class="fs-3 fw-bold text-danger"><?= formatMoney($kpis['descuentos'] ?? 0, Auth::moneda()) ?></div>
            <div class="text-muted small">Total Descuentos</div>
        </div>
    </div>
</div>

<!-- Tabla de resultados -->
<div class="card border-0 shadow-sm">
    <div class="card-header bg-transparent d-flex justify-content-between align-items-center">
        <h6 class="mb-0 fw-semibold">Detalle por <?= ucfirst(get('agrupar', 'día')) ?></h6>
        <span class="badge bg-secondary"><?= count($datos) ?> registros</span>
    </div>
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-hover align-middle mb-0">
                <thead class="table-light">
                    <tr>
                        <th><?= ucfirst(get('agrupar', 'Período')) ?></th>
                        <th class="text-center">N° Ventas</th>
                        <th class="text-end">Subtotal</th>
                        <th class="text-end">Descuentos</th>
                        <th class="text-end">Total</th>
                        <th class="text-end">Promedio</th>
                    </tr>
                </thead>
                <tbody>
                <?php foreach ($datos as $d): ?>
                <tr>
                    <td class="fw-medium small"><?= clean($d['periodo'] ?? $d['nombre'] ?? '-') ?></td>
                    <td class="text-center small"><?= $d['cantidad'] ?></td>
                    <td class="text-end small"><?= formatMoney($d['subtotal'] ?? 0, Auth::moneda()) ?></td>
                    <td class="text-end small text-danger"><?= $d['descuentos'] > 0 ? '-' . formatMoney($d['descuentos'], Auth::moneda()) : '-' ?></td>
                    <td class="text-end small fw-bold"><?= formatMoney($d['total'], Auth::moneda()) ?></td>
                    <td class="text-end small text-muted"><?= formatMoney($d['promedio'] ?? 0, Auth::moneda()) ?></td>
                </tr>
                <?php endforeach; ?>
                <?php if (empty($datos)): ?>
                <tr>
                    <td colspan="6" class="text-center text-muted py-4">No hay ventas en el período seleccionado.</td>
                </tr>
                <?php endif; ?>
                </tbody>
                <?php if (!empty($datos)): ?>
                <tfoot class="table-light fw-bold">
                    <tr>
                        <td>TOTAL</td>
                        <td class="text-center"><?= $kpis['cantidad'] ?? 0 ?></td>
                        <td class="text-end"><?= formatMoney(array_sum(array_column($datos, 'subtotal')), Auth::moneda()) ?></td>
                        <td class="text-end text-danger"><?= formatMoney($kpis['descuentos'] ?? 0, Auth::moneda()) ?></td>
                        <td class="text-end text-success"><?= formatMoney($kpis['total'] ?? 0, Auth::moneda()) ?></td>
                        <td></td>
                    </tr>
                </tfoot>
                <?php endif; ?>
            </table>
        </div>
    </div>
</div>
