<?php /* Vista: Ver Paciente */ ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h4 class="mb-0 fw-bold">
        <i class="bi bi-person text-primary me-2"></i>
        <?= clean($paciente['nombre'] . ' ' . $paciente['apellido']) ?>
    </h4>
    <div class="d-flex gap-2">
        <?php if (can('recetas.crear')): ?>
        <a href="<?= BASE_URL ?>/recetas/create?paciente_id=<?= $paciente['id'] ?>" class="btn btn-success btn-sm">
            <i class="bi bi-eyeglasses me-1"></i>Nueva Receta
        </a>
        <?php endif; ?>
        <?php if (can('ventas.crear')): ?>
        <a href="<?= BASE_URL ?>/ventas/create?paciente_id=<?= $paciente['id'] ?>" class="btn btn-outline-success btn-sm">
            <i class="bi bi-receipt me-1"></i>Nueva Venta
        </a>
        <?php endif; ?>
        <?php if (can('pacientes.editar')): ?>
        <a href="<?= BASE_URL ?>/pacientes/<?= $paciente['id'] ?>/edit" class="btn btn-primary btn-sm">
            <i class="bi bi-pencil me-1"></i>Editar
        </a>
        <?php endif; ?>
        <a href="<?= BASE_URL ?>/pacientes" class="btn btn-outline-secondary btn-sm">
            <i class="bi bi-arrow-left me-1"></i>Volver
        </a>
    </div>
</div>

<div class="row g-3">
    <!-- Datos del paciente -->
    <div class="col-lg-4">
        <div class="card border-0 shadow-sm mb-3">
            <div class="card-body">
                <div class="text-center mb-3">
                    <div class="rounded-circle bg-primary bg-opacity-10 d-inline-flex align-items-center justify-content-center mb-2"
                         style="width:72px;height:72px;font-size:24px;font-weight:700;color:var(--bs-primary)">
                        <?= strtoupper(substr($paciente['nombre'], 0, 1) . substr($paciente['apellido'], 0, 1)) ?>
                    </div>
                    <h6 class="fw-bold mb-0"><?= clean($paciente['nombre'] . ' ' . $paciente['apellido']) ?></h6>
                    <?php if ($paciente['fecha_nacimiento']): ?>
                    <div class="text-muted small"><?= calcularEdad($paciente['fecha_nacimiento']) ?> años</div>
                    <?php endif; ?>
                </div>
                <dl class="row mb-0 small">
                    <?php if ($paciente['rut']): ?>
                    <dt class="col-5 text-muted">RUT</dt>
                    <dd class="col-7"><?= clean($paciente['rut']) ?></dd>
                    <?php endif; ?>
                    <?php if ($paciente['sexo']): ?>
                    <dt class="col-5 text-muted">Sexo</dt>
                    <dd class="col-7"><?= $paciente['sexo'] === 'M' ? 'Masculino' : ($paciente['sexo'] === 'F' ? 'Femenino' : 'Otro') ?></dd>
                    <?php endif; ?>
                    <?php if ($paciente['telefono']): ?>
                    <dt class="col-5 text-muted">Teléfono</dt>
                    <dd class="col-7"><?= clean($paciente['telefono']) ?></dd>
                    <?php endif; ?>
                    <?php if ($paciente['email']): ?>
                    <dt class="col-5 text-muted">Email</dt>
                    <dd class="col-7 text-break"><?= clean($paciente['email']) ?></dd>
                    <?php endif; ?>
                    <?php if ($paciente['direccion']): ?>
                    <dt class="col-5 text-muted">Dirección</dt>
                    <dd class="col-7"><?= clean($paciente['direccion']) ?></dd>
                    <?php endif; ?>
                    <?php if ($paciente['prevision']): ?>
                    <dt class="col-5 text-muted">Previsión</dt>
                    <dd class="col-7"><?= clean($paciente['prevision']) ?></dd>
                    <?php endif; ?>
                </dl>
            </div>
        </div>

        <?php if ($paciente['antecedentes'] || $paciente['observaciones']): ?>
        <div class="card border-0 shadow-sm">
            <div class="card-header bg-transparent"><h6 class="mb-0 fw-semibold">Notas Médicas</h6></div>
            <div class="card-body small">
                <?php if ($paciente['antecedentes']): ?>
                <p class="mb-1"><strong>Antecedentes:</strong> <?= clean($paciente['antecedentes']) ?></p>
                <?php endif; ?>
                <?php if ($paciente['observaciones']): ?>
                <p class="mb-0"><strong>Observaciones:</strong> <?= clean($paciente['observaciones']) ?></p>
                <?php endif; ?>
            </div>
        </div>
        <?php endif; ?>
    </div>

    <div class="col-lg-8">
        <!-- Recetas -->
        <div class="card border-0 shadow-sm mb-3">
            <div class="card-header bg-transparent d-flex justify-content-between align-items-center">
                <h6 class="mb-0 fw-semibold"><i class="bi bi-eyeglasses me-2"></i>Recetas (<?= count($recetas) ?>)</h6>
                <?php if (can('recetas.crear')): ?>
                <a href="<?= BASE_URL ?>/recetas/create?paciente_id=<?= $paciente['id'] ?>" class="btn btn-sm btn-outline-success">
                    <i class="bi bi-plus-lg me-1"></i>Nueva
                </a>
                <?php endif; ?>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-sm table-hover mb-0">
                        <thead class="table-light">
                            <tr><th>Fecha</th><th>OD Esf</th><th>OI Esf</th><th>Optometrista</th><th></th></tr>
                        </thead>
                        <tbody>
                        <?php foreach ($recetas as $r): ?>
                        <tr>
                            <td class="small"><?= formatDate($r['fecha']) ?></td>
                            <td class="small"><?= formatReceta($r['od_esfera']) ?></td>
                            <td class="small"><?= formatReceta($r['oi_esfera']) ?></td>
                            <td class="small text-muted"><?= clean($r['optometrista_nombre'] ?? '-') ?></td>
                            <td>
                                <a href="<?= BASE_URL ?>/recetas/<?= $r['id'] ?>" class="btn btn-xs btn-outline-secondary"
                                   style="font-size:11px;padding:1px 6px">Ver</a>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                        <?php if (empty($recetas)): ?>
                        <tr><td colspan="5" class="text-center text-muted py-2 small">Sin recetas</td></tr>
                        <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <!-- Ventas -->
        <div class="card border-0 shadow-sm">
            <div class="card-header bg-transparent d-flex justify-content-between align-items-center">
                <h6 class="mb-0 fw-semibold"><i class="bi bi-receipt me-2"></i>Ventas (<?= count($ventas) ?>)</h6>
                <?php if (can('ventas.crear')): ?>
                <a href="<?= BASE_URL ?>/ventas/create?paciente_id=<?= $paciente['id'] ?>" class="btn btn-sm btn-outline-success">
                    <i class="bi bi-plus-lg me-1"></i>Nueva
                </a>
                <?php endif; ?>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-sm table-hover mb-0">
                        <thead class="table-light">
                            <tr><th>#</th><th>Total</th><th>Estado</th><th>Fecha</th><th></th></tr>
                        </thead>
                        <tbody>
                        <?php foreach ($ventas as $v): ?>
                        <tr>
                            <td class="small fw-medium"><?= clean($v['correlativo']) ?></td>
                            <td class="small"><?= formatMoney($v['total'], Auth::moneda()) ?></td>
                            <td><?= statusBadge($v['estado']) ?></td>
                            <td class="small text-muted"><?= formatDate($v['created_at']) ?></td>
                            <td>
                                <a href="<?= BASE_URL ?>/ventas/<?= $v['id'] ?>" class="btn btn-xs btn-outline-secondary"
                                   style="font-size:11px;padding:1px 6px">Ver</a>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                        <?php if (empty($ventas)): ?>
                        <tr><td colspan="5" class="text-center text-muted py-2 small">Sin ventas</td></tr>
                        <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
