<?php /* Vista: Marcas */ ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h4 class="mb-0 fw-bold"><i class="bi bi-bookmark-star text-primary me-2"></i>Marcas</h4>
    <?php if (can('marcas.crear')): ?>
    <a href="<?= BASE_URL ?>/marcas/create" class="btn btn-primary">
        <i class="bi bi-plus-lg me-1"></i>Nueva Marca
    </a>
    <?php endif; ?>
</div>

<!-- Filtros -->
<div class="card border-0 shadow-sm mb-3">
    <div class="card-body py-2">
        <form method="GET" action="<?= BASE_URL ?>/marcas" class="d-flex gap-2 flex-wrap align-items-center">
            <input type="text" name="q" class="form-control" style="max-width:280px"
                   placeholder="Buscar marca..." value="<?= clean($busqueda ?? '') ?>">
            <button type="submit" class="btn btn-outline-primary"><i class="bi bi-search"></i></button>
            <?php if (!empty($busqueda)): ?>
            <a href="<?= BASE_URL ?>/marcas" class="btn btn-outline-secondary"><i class="bi bi-x-lg"></i></a>
            <?php endif; ?>
        </form>
    </div>
</div>

<div class="card border-0 shadow-sm">
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-hover align-middle mb-0">
                <thead class="table-light">
                    <tr>
                        <th>#</th>
                        <th>Nombre</th>
                        <th>Descripción</th>
                        <th>Estado</th>
                        <th class="text-end">Acciones</th>
                    </tr>
                </thead>
                <tbody>
                <?php foreach ($marcas as $marca): ?>
                <tr>
                    <td class="text-muted small"><?= $marca['id'] ?></td>
                    <td class="fw-semibold"><?= clean($marca['nombre']) ?></td>
                    <td class="text-muted small"><?= clean($marca['descripcion'] ?? '-') ?></td>
                    <td><?= statusBadge($marca['estado']) ?></td>
                    <td class="text-end">
                        <div class="btn-group btn-group-sm">
                            <?php if (can('marcas.editar')): ?>
                            <a href="<?= BASE_URL ?>/marcas/<?= $marca['id'] ?>/edit"
                               class="btn btn-outline-primary" title="Editar">
                                <i class="bi bi-pencil"></i>
                            </a>
                            <?php endif; ?>
                            <?php if (can('marcas.eliminar')): ?>
                            <form method="POST" action="<?= BASE_URL ?>/marcas/<?= $marca['id'] ?>/delete"
                                  data-confirm="¿Desactivar esta marca?">
                                <?= csrf_field() ?>
                                <button type="submit" class="btn btn-outline-danger" title="Desactivar">
                                    <i class="bi bi-trash"></i>
                                </button>
                            </form>
                            <?php endif; ?>
                        </div>
                    </td>
                </tr>
                <?php endforeach; ?>
                <?php if (empty($marcas)): ?>
                <tr>
                    <td colspan="5" class="text-center text-muted py-4">
                        <i class="bi bi-bookmark-star fs-3 d-block mb-2 opacity-25"></i>
                        No hay marcas registradas.
                    </td>
                </tr>
                <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
    <?php if (!empty($pagination) && $pagination['last_page'] > 1): ?>
    <div class="card-footer bg-white d-flex justify-content-between align-items-center">
        <small class="text-muted">
            Mostrando <?= $pagination['from'] ?>–<?= $pagination['to'] ?> de <?= $pagination['total'] ?>
        </small>
        <?= paginationLinks($pagination, BASE_URL . '/marcas') ?>
    </div>
    <?php endif; ?>
</div>
