<?php /* Vista: Editar Marca */ ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h4 class="mb-0 fw-bold"><i class="bi bi-bookmark-star text-primary me-2"></i>Editar Marca</h4>
    <a href="<?= BASE_URL ?>/marcas" class="btn btn-outline-secondary btn-sm">
        <i class="bi bi-arrow-left me-1"></i>Volver
    </a>
</div>

<div class="row justify-content-center">
<div class="col-lg-6">
<div class="card border-0 shadow-sm">
<div class="card-body p-4">
<form method="POST" action="<?= BASE_URL ?>/marcas/<?= $marca['id'] ?>">
    <?= csrf_field() ?>
    <div class="row g-3">
        <div class="col-12">
            <label class="form-label fw-medium">Nombre <span class="text-danger">*</span></label>
            <input type="text" name="nombre" class="form-control"
                   value="<?= clean($marca['nombre']) ?>" required autofocus>
        </div>
        <div class="col-12">
            <label class="form-label fw-medium">Descripción</label>
            <textarea name="descripcion" class="form-control" rows="3"><?= clean($marca['descripcion'] ?? '') ?></textarea>
        </div>
        <div class="col-12">
            <label class="form-label fw-medium">Estado</label>
            <select name="estado" class="form-select">
                <option value="activa"   <?= $marca['estado'] === 'activa'   ? 'selected' : '' ?>>Activa</option>
                <option value="inactiva" <?= $marca['estado'] === 'inactiva' ? 'selected' : '' ?>>Inactiva</option>
            </select>
        </div>
        <div class="col-12 d-flex gap-2 justify-content-end mt-2">
            <a href="<?= BASE_URL ?>/marcas" class="btn btn-outline-secondary">Cancelar</a>
            <button type="submit" class="btn btn-primary px-4">
                <i class="bi bi-check-lg me-1"></i>Guardar Cambios
            </button>
        </div>
    </div>
</form>
</div>
</div>
</div>
</div>
