<?php /* Vista: Ver Empresa */ ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h4 class="mb-0 fw-bold">
        <i class="bi bi-building text-primary me-2"></i><?= clean($empresa['nombre']) ?>
    </h4>
    <div class="d-flex gap-2">
        <a href="<?= BASE_URL ?>/empresas/<?= $empresa['id'] ?>/edit" class="btn btn-primary btn-sm">
            <i class="bi bi-pencil me-1"></i>Editar
        </a>
        <a href="<?= BASE_URL ?>/empresas" class="btn btn-outline-secondary btn-sm">
            <i class="bi bi-arrow-left me-1"></i>Volver
        </a>
    </div>
</div>

<div class="row g-3">
    <!-- Info empresa -->
    <div class="col-lg-4">
        <div class="card border-0 shadow-sm">
            <div class="card-body text-center p-4">
                <?php if ($empresa['logo']): ?>
                <img src="<?= BASE_URL . '/' . $empresa['logo'] ?>" height="80" class="mb-3 rounded" alt="Logo">
                <?php else: ?>
                <div class="rounded-circle bg-primary bg-opacity-10 d-inline-flex align-items-center justify-content-center mb-3"
                     style="width:80px;height:80px">
                    <i class="bi bi-building text-primary fs-2"></i>
                </div>
                <?php endif; ?>
                <h5 class="fw-bold mb-1"><?= clean($empresa['nombre']) ?></h5>
                <?php if ($empresa['razon_social']): ?>
                <p class="text-muted small mb-1"><?= clean($empresa['razon_social']) ?></p>
                <?php endif; ?>
                <?= statusBadge($empresa['estado']) ?>
            </div>
            <div class="card-body border-top pt-3">
                <dl class="row mb-0 small">
                    <?php if ($empresa['rut']): ?>
                    <dt class="col-5 text-muted">RUT</dt>
                    <dd class="col-7"><?= clean($empresa['rut']) ?></dd>
                    <?php endif; ?>
                    <?php if ($empresa['email']): ?>
                    <dt class="col-5 text-muted">Email</dt>
                    <dd class="col-7"><?= clean($empresa['email']) ?></dd>
                    <?php endif; ?>
                    <?php if ($empresa['telefono']): ?>
                    <dt class="col-5 text-muted">Teléfono</dt>
                    <dd class="col-7"><?= clean($empresa['telefono']) ?></dd>
                    <?php endif; ?>
                    <?php if ($empresa['ciudad']): ?>
                    <dt class="col-5 text-muted">Ciudad</dt>
                    <dd class="col-7"><?= clean($empresa['ciudad']) ?>, <?= clean($empresa['pais']) ?></dd>
                    <?php endif; ?>
                    <dt class="col-5 text-muted">Moneda</dt>
                    <dd class="col-7"><?= clean($empresa['moneda']) ?></dd>
                    <dt class="col-5 text-muted">Registro</dt>
                    <dd class="col-7"><?= formatDate($empresa['created_at']) ?></dd>
                </dl>
            </div>
        </div>
    </div>

    <div class="col-lg-8">
        <!-- Licencias -->
        <div class="card border-0 shadow-sm mb-3">
            <div class="card-header bg-transparent d-flex justify-content-between align-items-center">
                <h6 class="mb-0 fw-semibold"><i class="bi bi-key me-2"></i>Licencias</h6>
                <a href="<?= BASE_URL ?>/licencias/create?empresa_id=<?= $empresa['id'] ?>" class="btn btn-sm btn-outline-primary">
                    <i class="bi bi-plus-lg me-1"></i>Nueva
                </a>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-sm mb-0">
                        <thead class="table-light">
                            <tr><th>Plan</th><th>Tipo</th><th>Inicio</th><th>Fin</th><th>Estado</th><th>Acciones</th></tr>
                        </thead>
                        <tbody>
                        <?php foreach ($licencias as $l): ?>
                        <tr>
                            <td class="small"><?= clean($l['plan_nombre']) ?></td>
                            <td><span class="badge bg-secondary"><?= $l['tipo'] ?></span></td>
                            <td class="small"><?= formatDate($l['fecha_inicio']) ?></td>
                            <td class="small"><?= $l['fecha_fin'] ? formatDate($l['fecha_fin']) : '∞' ?></td>
                            <td><?= statusBadge($l['estado']) ?></td>
                            <td>
                                <?php if ($l['estado'] === 'activa'): ?>
                                <form method="POST" action="<?= BASE_URL ?>/licencias/<?= $l['id'] ?>/suspender"
                                      class="d-inline" data-confirm="¿Suspender licencia?">
                                    <?= csrf_field() ?>
                                    <button class="btn btn-xs btn-outline-warning" style="font-size:11px;padding:1px 6px">Suspender</button>
                                </form>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                        <?php if (empty($licencias)): ?>
                        <tr><td colspan="6" class="text-center text-muted py-2 small">Sin licencias</td></tr>
                        <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <!-- Sucursales -->
        <div class="card border-0 shadow-sm mb-3">
            <div class="card-header bg-transparent">
                <h6 class="mb-0 fw-semibold"><i class="bi bi-shop me-2"></i>Sucursales (<?= count($sucursales) ?>)</h6>
            </div>
            <div class="card-body p-0">
                <ul class="list-group list-group-flush">
                <?php foreach ($sucursales as $s): ?>
                <li class="list-group-item d-flex justify-content-between align-items-center">
                    <div>
                        <span class="fw-medium small"><?= clean($s['nombre']) ?></span>
                        <?php if ($s['es_principal']): ?>
                        <span class="badge bg-primary ms-1" style="font-size:10px">Principal</span>
                        <?php endif; ?>
                        <?php if ($s['direccion']): ?>
                        <div class="text-muted" style="font-size:11px"><?= clean($s['direccion']) ?></div>
                        <?php endif; ?>
                    </div>
                    <?= statusBadge($s['estado']) ?>
                </li>
                <?php endforeach; ?>
                </ul>
            </div>
        </div>

        <!-- Usuarios -->
        <div class="card border-0 shadow-sm">
            <div class="card-header bg-transparent">
                <h6 class="mb-0 fw-semibold"><i class="bi bi-people me-2"></i>Usuarios (<?= count($usuarios) ?>)</h6>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-sm mb-0">
                        <thead class="table-light">
                            <tr><th>Nombre</th><th>Email</th><th>Rol</th><th>Estado</th></tr>
                        </thead>
                        <tbody>
                        <?php foreach ($usuarios as $u): ?>
                        <tr>
                            <td class="small fw-medium"><?= clean($u['nombre'] . ' ' . $u['apellido']) ?></td>
                            <td class="small text-muted"><?= clean($u['email']) ?></td>
                            <td><span class="badge bg-secondary"><?= clean($u['rol_nombre']) ?></span></td>
                            <td><?= statusBadge($u['estado']) ?></td>
                        </tr>
                        <?php endforeach; ?>
                        <?php if (empty($usuarios)): ?>
                        <tr><td colspan="4" class="text-center text-muted py-2 small">Sin usuarios</td></tr>
                        <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
