<?php /* Vista: Caja */ ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h4 class="mb-0 fw-bold"><i class="bi bi-cash-register text-primary me-2"></i>Caja</h4>
    <?php if (!$cajaAbierta && can('caja.abrir')): ?>
    <a href="<?= BASE_URL ?>/caja/apertura" class="btn btn-success">
        <i class="bi bi-unlock me-1"></i>Abrir Caja
    </a>
    <?php endif; ?>
</div>

<?php if ($cajaAbierta): ?>
<!-- Caja abierta -->
<div class="alert alert-success d-flex align-items-center gap-3 mb-4">
    <i class="bi bi-check-circle-fill fs-4"></i>
    <div>
    <strong>Caja abierta</strong> desde <?= formatDateTime($cajaAbierta['fecha_apertura']) ?>
        — Saldo inicial: <strong><?= formatMoney($cajaAbierta['monto_apertura'], Auth::moneda()) ?></strong>
    </div>
    <div class="ms-auto d-flex gap-2">
        <a href="<?= BASE_URL ?>/caja/<?= $cajaAbierta['id'] ?>" class="btn btn-sm btn-outline-success">
            <i class="bi bi-eye me-1"></i>Ver Detalle
        </a>
        <?php if (can('caja.cerrar')): ?>
        <a href="<?= BASE_URL ?>/caja/cierre" class="btn btn-sm btn-danger">
            <i class="bi bi-lock me-1"></i>Cerrar Caja
        </a>
        <?php endif; ?>
    </div>
</div>

<!-- Resumen de la caja actual -->
<div class="row g-3 mb-4">
    <div class="col-sm-6 col-xl-3">
        <div class="card border-0 shadow-sm text-center py-3">
            <div class="fs-3 fw-bold text-success"><?= formatMoney($resumen['total_ventas'] ?? 0, Auth::moneda()) ?></div>
            <div class="text-muted small">Ventas del Día</div>
        </div>
    </div>
    <div class="col-sm-6 col-xl-3">
        <div class="card border-0 shadow-sm text-center py-3">
            <div class="fs-3 fw-bold text-primary"><?= $resumen['cantidad_ventas'] ?? 0 ?></div>
            <div class="text-muted small">N° Ventas</div>
        </div>
    </div>
    <div class="col-sm-6 col-xl-3">
        <div class="card border-0 shadow-sm text-center py-3">
            <div class="fs-3 fw-bold text-warning"><?= formatMoney($resumen['total_egresos'] ?? 0, Auth::moneda()) ?></div>
            <div class="text-muted small">Egresos</div>
        </div>
    </div>
    <div class="col-sm-6 col-xl-3">
        <div class="card border-0 shadow-sm text-center py-3">
            <div class="fs-3 fw-bold text-info"><?= formatMoney(($cajaAbierta['monto_apertura'] + ($resumen['total_ventas'] ?? 0) - ($resumen['total_egresos'] ?? 0)), Auth::moneda()) ?></div>
            <div class="text-muted small">Saldo Estimado</div>
        </div>
    </div>
</div>

<!-- Movimientos de caja -->
<div class="card border-0 shadow-sm">
    <div class="card-header bg-transparent d-flex justify-content-between align-items-center">
        <h6 class="mb-0 fw-semibold">Movimientos de Hoy</h6>
        <?php if (can('caja.movimiento')): ?>
        <button type="button" class="btn btn-sm btn-outline-primary" data-bs-toggle="modal" data-bs-target="#modalMovimiento">
            <i class="bi bi-plus-lg me-1"></i>Registrar Movimiento
        </button>
        <?php endif; ?>
    </div>
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-sm table-hover mb-0">
                <thead class="table-light">
                    <tr><th>Tipo</th><th>Concepto</th><th>Monto</th><th>Usuario</th><th>Hora</th></tr>
                </thead>
                <tbody>
                <?php foreach ($movimientos as $m): ?>
                <tr>
                    <td>
                        <span class="badge bg-<?= $m['tipo'] === 'ingreso' ? 'success' : 'danger' ?>">
                            <?= $m['tipo'] ?>
                        </span>
                    </td>
                    <td class="small"><?= clean($m['concepto']) ?></td>
                    <td class="small fw-medium <?= $m['tipo'] === 'ingreso' ? 'text-success' : 'text-danger' ?>">
                        <?= $m['tipo'] === 'egreso' ? '-' : '' ?><?= formatMoney($m['monto'], Auth::moneda()) ?>
                    </td>
                    <td class="small text-muted"><?= clean($m['usuario_nombre'] ?? '-') ?></td>
                    <td class="small text-muted"><?= formatDateTime($m['fecha'], 'H:i') ?></td>
                </tr>
                <?php endforeach; ?>
                <?php if (empty($movimientos)): ?>
                <tr><td colspan="5" class="text-center text-muted py-3">Sin movimientos registrados.</td></tr>
                <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Modal movimiento -->
<div class="modal fade" id="modalMovimiento" tabindex="-1">
    <div class="modal-dialog modal-sm">
        <div class="modal-content">
            <div class="modal-header">
                <h6 class="modal-title fw-semibold">Registrar Movimiento</h6>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST" action="<?= BASE_URL ?>/caja/movimiento">
                <?= csrf_field() ?>
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label fw-medium small">Tipo</label>
                        <select name="tipo" class="form-select form-select-sm" required>
                            <option value="ingreso">Ingreso</option>
                            <option value="egreso">Egreso</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label fw-medium small">Concepto <span class="text-danger">*</span></label>
                        <input type="text" name="concepto" class="form-control form-control-sm" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label fw-medium small">Monto <span class="text-danger">*</span></label>
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">$</span>
                            <input type="number" name="monto" class="form-control" min="0.01" step="0.01" required>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-sm btn-outline-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-sm btn-primary">Registrar</button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php else: ?>
<!-- Caja cerrada -->
<div class="text-center py-5">
    <i class="bi bi-lock fs-1 text-muted d-block mb-3 opacity-50"></i>
    <h5 class="text-muted">La caja está cerrada</h5>
    <p class="text-muted small">Debes abrir la caja para registrar ventas y movimientos.</p>
    <?php if (can('caja.abrir')): ?>
    <a href="<?= BASE_URL ?>/caja/apertura" class="btn btn-success mt-2">
        <i class="bi bi-unlock me-1"></i>Abrir Caja Ahora
    </a>
    <?php endif; ?>
</div>

<!-- Historial de cajas -->
<?php if (!empty($historial)): ?>
<div class="card border-0 shadow-sm mt-4">
    <div class="card-header bg-transparent"><h6 class="mb-0 fw-semibold">Historial de Cajas</h6></div>
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-sm table-hover mb-0">
                <thead class="table-light">
                    <tr><th>Apertura</th><th>Cierre</th><th>Saldo Inicial</th><th>Total Ventas</th><th>Estado</th><th></th></tr>
                </thead>
                <tbody>
                <?php foreach ($historial as $h): ?>
                <tr>
                    <td class="small"><?= formatDateTime($h['fecha_apertura']) ?></td>
                    <td class="small text-muted"><?= $h['fecha_cierre'] ? formatDateTime($h['fecha_cierre']) : '-' ?></td>
                    <td class="small"><?= formatMoney($h['monto_apertura'], Auth::moneda()) ?></td>
                    <td class="small"><?= formatMoney($h['total_ventas'] ?? 0, Auth::moneda()) ?></td>
                    <td><?= statusBadge($h['estado']) ?></td>
                    <td>
                        <a href="<?= BASE_URL ?>/caja/<?= $h['id'] ?>" class="btn btn-xs btn-outline-secondary"
                           style="font-size:11px;padding:1px 6px">Ver</a>
                    </td>
                </tr>
                <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php endif; ?>
<?php endif; ?>
