<?php /* Vista: Restablecer Contraseña */ ?>

<div class="card shadow-sm border-0">
    <div class="card-body p-4">
        <div class="text-center mb-4">
            <div class="rounded-circle bg-success bg-opacity-10 d-inline-flex align-items-center justify-content-center mb-3"
                 style="width:56px;height:56px">
                <i class="bi bi-shield-lock fs-3 text-success"></i>
            </div>
            <h5 class="card-title fw-semibold mb-1">Nueva Contraseña</h5>
            <p class="text-muted small mb-0">
                Restableciendo contraseña para <strong><?= clean($email ?? '') ?></strong>
            </p>
        </div>

        <form method="POST" action="<?= BASE_URL ?>/reset-password" novalidate>
            <?= csrf_field() ?>
            <input type="hidden" name="token" value="<?= clean($token ?? '') ?>">

            <div class="mb-3">
                <label for="password" class="form-label fw-medium">
                    <i class="bi bi-lock me-1"></i>Nueva contraseña
                </label>
                <div class="input-group">
                    <input type="password"
                           class="form-control form-control-lg"
                           id="password"
                           name="password"
                           placeholder="Mínimo 8 caracteres"
                           minlength="8"
                           required
                           autofocus>
                    <button class="btn btn-outline-secondary" type="button" id="togglePwd" tabindex="-1">
                        <i class="bi bi-eye" id="toggleIcon1"></i>
                    </button>
                </div>
            </div>

            <div class="mb-4">
                <label for="password_confirm" class="form-label fw-medium">
                    <i class="bi bi-lock-fill me-1"></i>Confirmar contraseña
                </label>
                <div class="input-group">
                    <input type="password"
                           class="form-control form-control-lg"
                           id="password_confirm"
                           name="password_confirm"
                           placeholder="Repite la contraseña"
                           minlength="8"
                           required>
                    <button class="btn btn-outline-secondary" type="button" id="togglePwd2" tabindex="-1">
                        <i class="bi bi-eye" id="toggleIcon2"></i>
                    </button>
                </div>
                <div id="matchMsg" class="form-text"></div>
            </div>

            <div class="d-grid mb-3">
                <button type="submit" class="btn btn-success btn-lg fw-semibold" id="btnSubmit">
                    <i class="bi bi-check-circle me-2"></i>Restablecer Contraseña
                </button>
            </div>

            <div class="text-center">
                <a href="<?= BASE_URL ?>/login" class="text-muted small text-decoration-none">
                    <i class="bi bi-arrow-left me-1"></i>Volver al inicio de sesión
                </a>
            </div>
        </form>
    </div>
</div>

<script>
// Toggle password visibility
function toggleVisibility(btnId, inputId, iconId) {
    document.getElementById(btnId).addEventListener('click', function () {
        const input = document.getElementById(inputId);
        const icon  = document.getElementById(iconId);
        if (input.type === 'password') {
            input.type = 'text';
            icon.classList.replace('bi-eye', 'bi-eye-slash');
        } else {
            input.type = 'password';
            icon.classList.replace('bi-eye-slash', 'bi-eye');
        }
    });
}
toggleVisibility('togglePwd',  'password',         'toggleIcon1');
toggleVisibility('togglePwd2', 'password_confirm', 'toggleIcon2');

// Password match validation
const pwd1    = document.getElementById('password');
const pwd2    = document.getElementById('password_confirm');
const msg     = document.getElementById('matchMsg');
const btnSub  = document.getElementById('btnSubmit');

function checkMatch() {
    if (!pwd2.value) { msg.textContent = ''; return; }
    if (pwd1.value === pwd2.value) {
        msg.textContent = '✓ Las contraseñas coinciden';
        msg.className   = 'form-text text-success';
        btnSub.disabled = false;
    } else {
        msg.textContent = '✗ Las contraseñas no coinciden';
        msg.className   = 'form-text text-danger';
        btnSub.disabled = true;
    }
}
pwd1.addEventListener('input', checkMatch);
pwd2.addEventListener('input', checkMatch);
</script>
