<?php /* Vista: Audit Logs */ ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h4 class="mb-0 fw-bold"><i class="bi bi-journal-text text-primary me-2"></i>Audit Logs</h4>
    <span class="badge bg-secondary fs-6"><?= number_format($pagination['total']) ?> registros</span>
</div>

<!-- Filtros -->
<div class="card border-0 shadow-sm mb-4">
    <div class="card-body">
        <form method="GET" action="<?= BASE_URL ?>/audit-logs" class="row g-2 align-items-end">
            <div class="col-sm-6 col-md-2">
                <label class="form-label small fw-medium">Desde</label>
                <input type="date" name="desde" class="form-control form-control-sm"
                       value="<?= clean($filtros['desde'] ?? date('Y-m-01')) ?>">
            </div>
            <div class="col-sm-6 col-md-2">
                <label class="form-label small fw-medium">Hasta</label>
                <input type="date" name="hasta" class="form-control form-control-sm"
                       value="<?= clean($filtros['hasta'] ?? date('Y-m-d')) ?>">
            </div>
            <div class="col-sm-6 col-md-2">
                <label class="form-label small fw-medium">Usuario</label>
                <select name="usuario_id" class="form-select form-select-sm">
                    <option value="">Todos</option>
                    <?php foreach ($usuarios as $u): ?>
                    <option value="<?= $u['id'] ?>" <?= ($filtros['usuarioId'] ?? '') == $u['id'] ? 'selected' : '' ?>>
                        <?= clean($u['nombre']) ?>
                    </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="col-sm-6 col-md-2">
                <label class="form-label small fw-medium">Tabla</label>
                <select name="tabla" class="form-select form-select-sm">
                    <option value="">Todas</option>
                    <?php foreach ($tablas as $t): ?>
                    <option value="<?= clean($t) ?>" <?= ($filtros['tabla'] ?? '') === $t ? 'selected' : '' ?>>
                        <?= clean($t) ?>
                    </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="col-sm-6 col-md-2">
                <label class="form-label small fw-medium">Acción</label>
                <select name="accion" class="form-select form-select-sm">
                    <option value="">Todas</option>
                    <?php foreach ($acciones as $a): ?>
                    <option value="<?= clean($a) ?>" <?= ($filtros['accion'] ?? '') === $a ? 'selected' : '' ?>>
                        <?= clean($a) ?>
                    </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="col-sm-6 col-md-2 d-flex gap-2 align-items-end">
                <button type="submit" class="btn btn-primary btn-sm flex-fill">
                    <i class="bi bi-search me-1"></i>Filtrar
                </button>
                <a href="<?= BASE_URL ?>/audit-logs" class="btn btn-outline-secondary btn-sm">
                    <i class="bi bi-x-lg"></i>
                </a>
            </div>
        </form>
    </div>
</div>

<!-- Tabla de logs -->
<div class="card border-0 shadow-sm">
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-hover table-sm align-middle mb-0">
                <thead class="table-light">
                    <tr>
                        <th style="width:150px">Fecha</th>
                        <th>Usuario</th>
                        <th>Acción</th>
                        <th>Tabla</th>
                        <th class="text-center">ID Reg.</th>
                        <th>IP</th>
                        <th class="text-center">Detalle</th>
                    </tr>
                </thead>
                <tbody>
                <?php foreach ($logs as $log): ?>
                <?php
                $accionColor = match(true) {
                    str_contains($log['accion'], 'crear')   => 'success',
                    str_contains($log['accion'], 'editar')  => 'primary',
                    str_contains($log['accion'], 'eliminar'),
                    str_contains($log['accion'], 'desactivar'),
                    str_contains($log['accion'], 'anular')  => 'danger',
                    str_contains($log['accion'], 'login')   => 'info',
                    str_contains($log['accion'], 'logout')  => 'secondary',
                    default                                  => 'warning',
                };
                ?>
                <tr>
                    <td class="small text-muted font-monospace">
                        <?= date('d/m/Y H:i:s', strtotime($log['fecha'])) ?>
                    </td>
                    <td class="small">
                        <?php if ($log['usuario_nombre']): ?>
                            <span class="fw-medium"><?= clean($log['usuario_nombre']) ?></span>
                            <br><span class="text-muted" style="font-size:11px"><?= clean($log['usuario_email'] ?? '') ?></span>
                        <?php else: ?>
                            <span class="text-muted">Sistema</span>
                        <?php endif; ?>
                    </td>
                    <td>
                        <span class="badge bg-<?= $accionColor ?> bg-opacity-75 text-dark fw-normal">
                            <?= clean($log['accion']) ?>
                        </span>
                    </td>
                    <td class="small font-monospace text-muted"><?= clean($log['tabla'] ?? '-') ?></td>
                    <td class="text-center small text-muted"><?= $log['registro_id'] ?? '-' ?></td>
                    <td class="small font-monospace text-muted"><?= clean($log['ip'] ?? '-') ?></td>
                    <td class="text-center">
                        <?php if ($log['datos_anteriores'] || $log['datos_nuevos']): ?>
                        <button type="button" class="btn btn-outline-secondary btn-sm py-0 px-1"
                                data-bs-toggle="modal" data-bs-target="#modalDetalle"
                                data-antes="<?= htmlspecialchars($log['datos_anteriores'] ?? 'null', ENT_QUOTES) ?>"
                                data-despues="<?= htmlspecialchars($log['datos_nuevos'] ?? 'null', ENT_QUOTES) ?>"
                                data-accion="<?= clean($log['accion']) ?>">
                            <i class="bi bi-eye" style="font-size:12px"></i>
                        </button>
                        <?php else: ?>
                            <span class="text-muted">—</span>
                        <?php endif; ?>
                    </td>
                </tr>
                <?php endforeach; ?>
                <?php if (empty($logs)): ?>
                <tr>
                    <td colspan="7" class="text-center text-muted py-5">
                        <i class="bi bi-journal-x fs-2 d-block mb-2 opacity-25"></i>
                        No hay registros de auditoría con los filtros seleccionados.
                    </td>
                </tr>
                <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Paginación -->
<?php if ($pagination['total_pages'] > 1): ?>
<nav class="mt-3">
    <ul class="pagination pagination-sm justify-content-center mb-0">
        <?php if ($pagination['current_page'] > 1): ?>
        <li class="page-item">
            <a class="page-link" href="?<?= http_build_query(array_merge($_GET, ['page' => $pagination['current_page'] - 1])) ?>">
                <i class="bi bi-chevron-left"></i>
            </a>
        </li>
        <?php endif; ?>

        <?php
        $start = max(1, $pagination['current_page'] - 2);
        $end   = min($pagination['total_pages'], $pagination['current_page'] + 2);
        for ($i = $start; $i <= $end; $i++):
        ?>
        <li class="page-item <?= $i === $pagination['current_page'] ? 'active' : '' ?>">
            <a class="page-link" href="?<?= http_build_query(array_merge($_GET, ['page' => $i])) ?>"><?= $i ?></a>
        </li>
        <?php endfor; ?>

        <?php if ($pagination['current_page'] < $pagination['total_pages']): ?>
        <li class="page-item">
            <a class="page-link" href="?<?= http_build_query(array_merge($_GET, ['page' => $pagination['current_page'] + 1])) ?>">
                <i class="bi bi-chevron-right"></i>
            </a>
        </li>
        <?php endif; ?>
    </ul>
</nav>
<?php endif; ?>

<!-- Modal Detalle -->
<div class="modal fade" id="modalDetalle" tabindex="-1">
    <div class="modal-dialog modal-lg modal-dialog-scrollable">
        <div class="modal-content">
            <div class="modal-header">
                <h6 class="modal-title fw-bold">
                    <i class="bi bi-journal-text me-2"></i>Detalle del Log: <span id="modalAccion"></span>
                </h6>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="row g-3">
                    <div class="col-md-6">
                        <h6 class="text-muted small fw-semibold mb-2">DATOS ANTERIORES</h6>
                        <pre id="modalAntes" class="bg-light rounded p-3 small" style="max-height:300px;overflow-y:auto;white-space:pre-wrap;word-break:break-all"></pre>
                    </div>
                    <div class="col-md-6">
                        <h6 class="text-muted small fw-semibold mb-2">DATOS NUEVOS</h6>
                        <pre id="modalDespues" class="bg-light rounded p-3 small" style="max-height:300px;overflow-y:auto;white-space:pre-wrap;word-break:break-all"></pre>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.getElementById('modalDetalle').addEventListener('show.bs.modal', function (e) {
    const btn     = e.relatedTarget;
    const antes   = btn.dataset.antes;
    const despues = btn.dataset.despues;
    const accion  = btn.dataset.accion;

    document.getElementById('modalAccion').textContent = accion;

    function prettyJson(str) {
        try { return JSON.stringify(JSON.parse(str), null, 2); }
        catch(e) { return str || '—'; }
    }

    document.getElementById('modalAntes').textContent   = prettyJson(antes);
    document.getElementById('modalDespues').textContent = prettyJson(despues);
});
</script>
