<?php /* Vista: Agenda / Citas */
$estadoClases = [
    'pendiente'   => 'bg-warning text-dark',
    'confirmada'  => 'bg-primary',
    'atendida'    => 'bg-success',
    'cancelada'   => 'bg-danger',
    'no_asistio'  => 'bg-secondary',
];
$estadoLabels = [
    'pendiente'   => 'Pendiente',
    'confirmada'  => 'Confirmada',
    'atendida'    => 'Atendida',
    'cancelada'   => 'Cancelada',
    'no_asistio'  => 'No Asistió',
];
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h4 class="mb-0 fw-bold"><i class="bi bi-calendar3 text-primary me-2"></i>Agenda</h4>
    <?php if (can('agenda.crear')): ?>
    <a href="<?= BASE_URL ?>/agenda/create" class="btn btn-primary">
        <i class="bi bi-plus-lg me-1"></i>Nueva Cita
    </a>
    <?php endif; ?>
</div>

<!-- Contadores del día -->
<div class="row g-3 mb-4">
    <div class="col-6 col-md-3">
        <div class="card border-0 shadow-sm text-center py-2">
            <div class="card-body py-2">
                <div class="fs-4 fw-bold text-warning"><?= $contadores['pendiente'] ?? 0 ?></div>
                <div class="text-muted small">Pendientes Hoy</div>
            </div>
        </div>
    </div>
    <div class="col-6 col-md-3">
        <div class="card border-0 shadow-sm text-center py-2">
            <div class="card-body py-2">
                <div class="fs-4 fw-bold text-primary"><?= $contadores['confirmada'] ?? 0 ?></div>
                <div class="text-muted small">Confirmadas Hoy</div>
            </div>
        </div>
    </div>
    <div class="col-6 col-md-3">
        <div class="card border-0 shadow-sm text-center py-2">
            <div class="card-body py-2">
                <div class="fs-4 fw-bold text-success"><?= $contadores['atendida'] ?? 0 ?></div>
                <div class="text-muted small">Atendidas Hoy</div>
            </div>
        </div>
    </div>
    <div class="col-6 col-md-3">
        <div class="card border-0 shadow-sm text-center py-2">
            <div class="card-body py-2">
                <div class="fs-4 fw-bold text-danger"><?= $contadores['cancelada'] ?? 0 ?></div>
                <div class="text-muted small">Canceladas Hoy</div>
            </div>
        </div>
    </div>
</div>

<!-- Filtros -->
<div class="card border-0 shadow-sm mb-3">
    <div class="card-body py-2">
        <form method="GET" action="<?= BASE_URL ?>/agenda" class="d-flex gap-2 flex-wrap align-items-center">
            <input type="text" name="q" class="form-control" style="max-width:200px"
                   placeholder="Buscar paciente..." value="<?= clean($filtros['q'] ?? '') ?>">
            <input type="date" name="desde" class="form-control" style="max-width:150px"
                   value="<?= clean($filtros['desde'] ?? date('Y-m-d')) ?>">
            <span class="text-muted">al</span>
            <input type="date" name="hasta" class="form-control" style="max-width:150px"
                   value="<?= clean($filtros['hasta'] ?? date('Y-m-d', strtotime('+7 days'))) ?>">
            <select name="estado" class="form-select" style="max-width:160px">
                <option value="">Todos los estados</option>
                <?php foreach ($estadoLabels as $val => $lbl): ?>
                <option value="<?= $val ?>" <?= ($filtros['estado'] ?? '') === $val ? 'selected' : '' ?>>
                    <?= $lbl ?>
                </option>
                <?php endforeach; ?>
            </select>
            <button type="submit" class="btn btn-outline-primary"><i class="bi bi-search"></i></button>
            <a href="<?= BASE_URL ?>/agenda" class="btn btn-outline-secondary"><i class="bi bi-x-lg"></i></a>
        </form>
    </div>
</div>

<div class="card border-0 shadow-sm">
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-hover align-middle mb-0">
                <thead class="table-light">
                    <tr>
                        <th>Fecha</th>
                        <th>Hora</th>
                        <th>Paciente</th>
                        <th>Motivo</th>
                        <th>Profesional</th>
                        <th>Estado</th>
                        <th class="text-end">Acciones</th>
                    </tr>
                </thead>
                <tbody>
                <?php foreach ($citas as $cita): ?>
                <?php
                $cls = $estadoClases[$cita['estado']] ?? 'bg-secondary';
                $lbl = $estadoLabels[$cita['estado']] ?? $cita['estado'];
                $esHoy = ($cita['fecha'] === date('Y-m-d'));
                ?>
                <tr class="<?= $esHoy ? 'table-active' : '' ?>">
                    <td>
                        <span class="fw-semibold <?= $esHoy ? 'text-primary' : '' ?>">
                            <?= date('d/m/Y', strtotime($cita['fecha'])) ?>
                        </span>
                        <?php if ($esHoy): ?>
                        <span class="badge bg-primary ms-1 small">Hoy</span>
                        <?php endif; ?>
                    </td>
                    <td class="fw-semibold"><?= substr($cita['hora'], 0, 5) ?></td>
                    <td>
                        <div class="fw-semibold"><?= clean($cita['nombre_paciente'] ?? $cita['paciente_nombre'] ?? 'Sin nombre') ?></div>
                        <?php if (!empty($cita['telefono_paciente'])): ?>
                        <div class="text-muted small"><i class="bi bi-telephone me-1"></i><?= clean($cita['telefono_paciente']) ?></div>
                        <?php endif; ?>
                    </td>
                    <td class="text-muted small"><?= truncate(clean($cita['motivo'] ?? ''), 35) ?></td>
                    <td class="text-muted small"><?= clean($cita['profesional'] ?? '-') ?></td>
                    <td>
                        <span class="badge <?= $cls ?>"><?= $lbl ?></span>
                    </td>
                    <td class="text-end">
                        <div class="btn-group btn-group-sm">
                            <?php if (can('agenda.editar')): ?>
                            <a href="<?= BASE_URL ?>/agenda/<?= $cita['id'] ?>/edit"
                               class="btn btn-outline-primary" title="Editar">
                                <i class="bi bi-pencil"></i>
                            </a>
                            <!-- Cambio rápido de estado -->
                            <?php if ($cita['estado'] === 'pendiente' || $cita['estado'] === 'confirmada'): ?>
                            <form method="POST" action="<?= BASE_URL ?>/agenda/<?= $cita['id'] ?>/estado">
                                <?= csrf_field() ?>
                                <input type="hidden" name="estado" value="atendida">
                                <button type="submit" class="btn btn-outline-success" title="Marcar como Atendida">
                                    <i class="bi bi-check-lg"></i>
                                </button>
                            </form>
                            <form method="POST" action="<?= BASE_URL ?>/agenda/<?= $cita['id'] ?>/estado"
                                  data-confirm="¿Cancelar esta cita?">
                                <?= csrf_field() ?>
                                <input type="hidden" name="estado" value="cancelada">
                                <button type="submit" class="btn btn-outline-danger" title="Cancelar">
                                    <i class="bi bi-x-lg"></i>
                                </button>
                            </form>
                            <?php endif; ?>
                            <?php endif; ?>
                            <?php if (can('agenda.eliminar')): ?>
                            <form method="POST" action="<?= BASE_URL ?>/agenda/<?= $cita['id'] ?>/delete"
                                  data-confirm="¿Eliminar esta cita?">
                                <?= csrf_field() ?>
                                <button type="submit" class="btn btn-outline-secondary" title="Eliminar">
                                    <i class="bi bi-trash"></i>
                                </button>
                            </form>
                            <?php endif; ?>
                        </div>
                    </td>
                </tr>
                <?php endforeach; ?>
                <?php if (empty($citas)): ?>
                <tr>
                    <td colspan="7" class="text-center text-muted py-4">
                        <i class="bi bi-calendar3 fs-3 d-block mb-2 opacity-25"></i>
                        No hay citas en el período seleccionado.
                    </td>
                </tr>
                <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
    <?php if (!empty($pagination) && $pagination['last_page'] > 1): ?>
    <div class="card-footer bg-white d-flex justify-content-between align-items-center">
        <small class="text-muted">
            Mostrando <?= $pagination['from'] ?>–<?= $pagination['to'] ?> de <?= $pagination['total'] ?>
        </small>
        <?= paginationLinks($pagination, BASE_URL . '/agenda') ?>
    </div>
    <?php endif; ?>
</div>
